/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.crypto.tools.commands.printers;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import javax.crypto.SecretKey;
import org.nhindirect.common.crypto.tools.commands.KeyModel;
import org.nhindirect.common.tooling.printer.AbstractRecordPrinter;

public class KeyPrinter
extends AbstractRecordPrinter<KeyModel> {
    protected static final Collection<AbstractRecordPrinter.ReportColumn> REPORT_COLS = new ArrayList<AbstractRecordPrinter.ReportColumn>();
    protected static final String KEY_NAME_COL = "Key Name";
    protected static final String KEY_TYPE_COL = "Key Type";
    protected static final String KEY_TEXT_COL = "Key Text";

    public KeyPrinter() {
        super(81, REPORT_COLS);
    }

    @Override
    protected String getColumnValue(AbstractRecordPrinter.ReportColumn column, KeyModel model) {
        try {
            if (column.getHeader().equals(KEY_TYPE_COL)) {
                String type = "";
                Key key = model.getKey();
                type = key instanceof SecretKey ? "Secret Key: " + key.getAlgorithm() : (key instanceof PublicKey ? "Public Key: " + key.getAlgorithm() : (key instanceof PrivateKey ? "Private Key: " + key.getAlgorithm() : key.getClass().toString()));
                return type;
            }
            if (column.getHeader().equals(KEY_TEXT_COL)) {
                return new String(model.getKeyText());
            }
            return super.getColumnValue(column, model);
        }
        catch (Exception e) {
            return "ERROR: " + e.getMessage();
        }
    }

    static {
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(KEY_NAME_COL, 40, "KeyName"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(KEY_TYPE_COL, 25, "KeyType"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(KEY_TEXT_COL, 16, "KeyText"));
    }
}

