/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.tooling;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.nhindirect.common.tooling.Action;
import org.nhindirect.common.tooling.Command;
import org.nhindirect.common.tooling.CommandDef;
import org.nhindirect.common.tooling.CommandUsage;
import org.nhindirect.common.tooling.StringArrayUtil;

public class Commands {
    static final String[] EmptyArgs = new String[0];
    private static final String SEARCH_USAGE = "Search for commands matching the given wildcard pattern\r\n\tpattern\r\n\tpattern: (optional) pattern, containing '*' wildcards";
    private static final String HELP_USAGE = "Show help\r\nhelp ['all' | name]\r\n\tall: All commands\r\n\tname: This command name or names with this PREFIX\r\nsearch [pattern]\r\nSearch for commands matching the given wildcard pattern\r\n\tpattern\r\n\tpattern: (optional) pattern, containing '*' wildcards";
    private static final String COMMANDS_USAGE = "List the commands available\r\ncommands [nameprefix]";
    private static final String EXIT_USAGE = "Exit the application";
    private static final String BATCH_USAGE = "Run a series of commands from a file\r\nEach command is on its own line. Comments begin with //\r\nfilepath [echo command (default true)]";
    private final String appName;
    private final List<Object> instances;
    private final Map<String, CommandDef> commands;
    private final Map<Class<?>, Object> typeLookup;
    private String[] commandNames;
    private boolean running;

    public Commands(String appName) {
        if (appName == null || appName.isEmpty()) {
            throw new IllegalArgumentException("appName value null or empty");
        }
        this.appName = appName;
        this.instances = new ArrayList<Object>();
        this.commands = new Hashtable<String, CommandDef>();
        this.typeLookup = new Hashtable();
        this.register(this);
    }

    public CommandDef getCommand(String name) {
        return this.commands.get(name.toUpperCase(Locale.getDefault()));
    }

    public Object getCommand(Class<?> clazz) {
        Object cmd = this.typeLookup.get(clazz);
        if (cmd == null) {
            throw new IllegalStateException("Command of type " + clazz.getName() + " was not found.");
        }
        return cmd;
    }

    public Collection<String> getCommandNames() {
        this.ensureCommandNamesArray();
        return Arrays.asList(this.commandNames);
    }

    public void register(Object instance) {
        if (instance == null) {
            throw new IllegalArgumentException("instance");
        }
        Class<?> type = instance.getClass();
        Method[] methods = type.getMethods();
        List<Method> commandMethods = methods != null && methods.length > 0 ? Arrays.asList(methods) : Collections.emptyList();
        this.instances.add(instance);
        this.typeLookup.put(instance.getClass(), instance);
        this.discoverCommandMethods(commandMethods, instance);
    }

    private void discoverCommandMethods(Collection<Method> methods, Object instance) {
        for (Method method : methods) {
            this.discoverCommandMethod(method, instance);
        }
    }

    private void discoverCommandMethod(Method method, Object instance) {
        Command cmd = method.getAnnotation(Command.class);
        if (cmd != null && cmd.name() != null && !cmd.name().isEmpty()) {
            final Object inst = instance;
            final Method meth = method;
            Action<String[]> action = new Action<String[]>(){

                @Override
                public void doAction(String[] params) {
                    block2: {
                        try {
                            meth.invoke(inst, new Object[]{params});
                        }
                        catch (Throwable e) {
                            Throwable error = e.getCause();
                            if (error == null) break block2;
                            System.err.println("\r\n" + error.getMessage());
                        }
                    }
                }
            };
            this.setEval(cmd.name(), action);
            final String usageStr = cmd.usage();
            if (usageStr != null && !usageStr.isEmpty()) {
                CommandUsage usage = new CommandUsage(){

                    @Override
                    public String getUsage() {
                        return usageStr;
                    }
                };
                this.setUsage(cmd.name(), usage);
            }
        }
    }

    public void runInteractive() {
        this.running = true;
        System.out.println(this.appName);
        InputStreamReader in = new InputStreamReader(System.in);
        BufferedReader reader = new BufferedReader(in);
        System.out.print(">");
        try {
            String input;
            while (this.running && (input = reader.readLine()) != null) {
                if (!input.isEmpty()) {
                    this.run(input);
                }
                if (!this.running) continue;
                System.out.print("\r\n>");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean run(String commandLine) {
        String[] args;
        if (commandLine != null && !commandLine.isEmpty() && (args = StringArrayUtil.parseAsCommandLine(commandLine)) != null && args.length > 0) {
            return this.run(args);
        }
        return false;
    }

    public boolean run(String[] args) {
        try {
            this.eval(args);
            return true;
        }
        catch (Exception ex) {
            this.handleError(ex);
            return false;
        }
    }

    public void eval(String[] input) throws Exception {
        if (input == null || input.length == 0) {
            return;
        }
        String commandName = input[0];
        CommandDef cmd = this.getCommand(commandName);
        if (cmd == null) {
            System.out.println(commandName.toUpperCase(Locale.getDefault()) + " not found.");
            System.out.println();
            System.out.println(HELP_USAGE);
            return;
        }
        try {
            String[] commandParams = input.length > 1 ? Arrays.copyOfRange(input, 1, input.length) : EmptyArgs;
            cmd.getEval().doAction(commandParams);
        }
        catch (Exception ex) {
            this.handleError(ex);
            System.out.println();
            cmd.showUsage();
            throw ex;
        }
    }

    public void showUsage(String cmdName) {
        if (cmdName == null || cmdName.isEmpty()) {
            this.showAllUsage();
        } else {
            this.bind(cmdName).showUsage();
        }
    }

    private void showAllUsage() {
        System.out.println("Registered commands");
        this.ensureCommandNamesArray();
        for (String name : this.commandNames) {
            this.showUsage(name);
        }
    }

    public Collection<String> prefixMatchCommandNames(String prefix) {
        this.ensureCommandNamesArray();
        ArrayList<String> retVal = new ArrayList<String>();
        for (String cmd : this.commandNames) {
            if (!cmd.toUpperCase(Locale.getDefault()).startsWith(prefix.toUpperCase(Locale.getDefault()))) continue;
            retVal.add(cmd);
        }
        return retVal;
    }

    public Collection<String> matchCommandNames(String pat) {
        this.ensureCommandNamesArray();
        Pattern pattern = Pattern.compile(pat);
        ArrayList<String> retVal = new ArrayList<String>();
        for (String cmd : this.commandNames) {
            Matcher matcher = pattern.matcher(cmd);
            if (!matcher.find()) continue;
            retVal.add(cmd);
        }
        return retVal;
    }

    CommandDef bind(String name) {
        CommandDef cmd = this.getCommand(name);
        if (cmd == null) {
            throw new IllegalArgumentException("Command " + name + " not found. Type help for usage.");
        }
        return cmd;
    }

    public void ensureCommandNamesArray() {
        if (this.commandNames != null && this.commandNames.length > 0) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        if (this.commands != null) {
            for (CommandDef cmd : this.commands.values()) {
                names.add(cmd.getName());
            }
            this.commandNames = names.toArray(new String[names.size()]);
        }
    }

    void setEval(String name, Action<String[]> eval) {
        this.ensure(name).setEval(eval);
    }

    void setUsage(String name, CommandUsage usage) {
        this.ensure(name).setUsage(usage);
    }

    private CommandDef ensure(String name) {
        CommandDef cmd = this.getCommand(name);
        if (cmd == null) {
            cmd = new CommandDef();
            cmd.setName(name);
            this.commands.put(name.toUpperCase(Locale.getDefault()), cmd);
        }
        return cmd;
    }

    void handleError(Exception ex) {
    }

    @Command(name="Quit", usage="Exit the application")
    public void quit(String[] args) {
        this.running = false;
    }

    @Command(name="Exit", usage="Exit the application")
    public void exit(String[] args) {
        this.running = false;
    }

    @Command(name="Commands", usage="List the commands available\r\ncommands [nameprefix]")
    public void listCommands(String[] args) {
        this.ensureCommandNamesArray();
        String prefix = args != null && args.length > 0 ? args[0] : null;
        Collection<String> names = prefix == null || prefix.isEmpty() ? Arrays.asList(this.commandNames) : this.prefixMatchCommandNames(prefix);
        for (String name : names) {
            this.bind(name).showCommand();
        }
    }

    @Command(name="Help", usage="Show help\r\nhelp ['all' | name]\r\n\tall: All commands\r\n\tname: This command name or names with this PREFIX\r\nsearch [pattern]\r\nSearch for commands matching the given wildcard pattern\r\n\tpattern\r\n\tpattern: (optional) pattern, containing '*' wildcards")
    public void help(String[] args) {
        String cmdName = null;
        if (args != null && args.length > 0) {
            cmdName = args[0];
        }
        if (cmdName == null || cmdName.isEmpty()) {
            System.out.println(HELP_USAGE);
            return;
        }
        if (cmdName.equalsIgnoreCase("all")) {
            this.showAllUsage();
            return;
        }
        CommandDef cmd = this.getCommand(cmdName);
        if (cmd != null) {
            cmd.showUsage();
            return;
        }
        for (String name : this.prefixMatchCommandNames(cmdName)) {
            this.bind(name).showUsage();
        }
    }

    @Command(name="Search", usage="Search for commands matching the given wildcard pattern\r\n\tpattern\r\n\tpattern: (optional) pattern, containing '*' wildcards")
    public void search(String[] args) {
        String pattern;
        String string = pattern = args != null && args.length > 0 ? args[0] : null;
        if (pattern == null || pattern.isEmpty()) {
            this.showAllUsage();
            return;
        }
        pattern = pattern.replace("*", ".*");
        for (String name : this.matchCommandNames(pattern)) {
            this.bind(name).showUsage();
        }
    }

    @Command(name="Batch", usage="Run a series of commands from a file\r\nEach command is on its own line. Comments begin with //\r\nfilepath [echo command (default true)]")
    public void batch(String[] args) {
        boolean echo;
        if (args == null || args.length == 0) {
            throw new IllegalArgumentException("Missing argument at position 0");
        }
        File file = new File(args[0]);
        boolean bl = echo = args != null && args.length > 1 ? Boolean.parseBoolean(args[1]) : true;
        if (!file.exists()) {
            throw new IllegalArgumentException("File " + file.getAbsolutePath() + " not found.");
        }
        try {
            List lines = FileUtils.readLines((File)file);
            for (String line : lines) {
                if ((line = line.trim()) == null || line.isEmpty() || line.startsWith("//")) continue;
                if (echo && !line.toUpperCase(Locale.getDefault()).startsWith("ECHO")) {
                    System.out.println(line);
                }
                this.run(line);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading file " + file.getAbsolutePath());
        }
    }

    @Command(name="Echo", usage="Echo the args to the console")
    public void echo(String[] args) {
        if (args == null || args.length == 0) {
            return;
        }
        for (String arg : args) {
            System.out.println(arg);
        }
    }
}

