/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.common.crypto.WrappableKeyProtectionManager;
import org.nhindirect.common.crypto.exceptions.CryptoException;
import org.nhindirect.stagent.AgentError;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.cert.X509CertificateEx;

public class WrappedOnDemandX509CertificateEx
extends X509CertificateEx {
    protected final KeyStoreProtectionManager mgr;
    protected final byte[] wrappedData;
    protected PrivateKey wrappedKey;

    public static X509CertificateEx fromX509Certificate(KeyStoreProtectionManager mgr, X509Certificate cert, byte[] wrappedData) {
        if (cert == null || wrappedData == null || wrappedData.length == 0) {
            throw new IllegalArgumentException("Cert or wrapped data cannot be null");
        }
        if (mgr == null) {
            throw new IllegalArgumentException("KeyStore manager cannot be null");
        }
        if (!(mgr instanceof WrappableKeyProtectionManager)) {
            throw new IllegalArgumentException("Key store must implement the WrappableKeyProtectionManager interface");
        }
        return new WrappedOnDemandX509CertificateEx(mgr, cert, wrappedData);
    }

    protected WrappedOnDemandX509CertificateEx(KeyStoreProtectionManager mgr, X509Certificate cert, byte[] wrappedData) {
        super(cert, null);
        this.mgr = mgr;
        this.wrappedData = wrappedData;
    }

    @Override
    public boolean hasPrivateKey() {
        return this.wrappedData != null;
    }

    @Override
    public synchronized PrivateKey getPrivateKey() {
        if (this.wrappedKey != null) {
            return this.wrappedKey;
        }
        WrappableKeyProtectionManager wrapManager = (WrappableKeyProtectionManager)this.mgr;
        String keyAlg = this.internalCert.getPublicKey().getAlgorithm();
        try {
            this.wrappedKey = (PrivateKey)wrapManager.unwrapWithSecretKey((SecretKey)this.mgr.getPrivateKeyProtectionKey(), this.wrappedData, keyAlg, 2);
        }
        catch (CryptoException e) {
            throw new NHINDException((Object)AgentError.Unexpected, "Failed to access wrapped private key.", (Exception)((Object)e));
        }
        return this.wrappedKey;
    }
}

