/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography;

import org.apache.commons.lang.StringUtils;
import org.bouncycastle.cms.CMSSignedDataGenerator;

public enum DigestAlgorithm {
    MD5("MD5", CMSSignedDataGenerator.DIGEST_MD5),
    SHA1("SHA1", CMSSignedDataGenerator.DIGEST_SHA1),
    SHA256("SHA256", CMSSignedDataGenerator.DIGEST_SHA256),
    SHA384("SHA384", CMSSignedDataGenerator.DIGEST_SHA384),
    SHA512("SHA512", CMSSignedDataGenerator.DIGEST_SHA512);

    protected final String algName;
    protected final String OID;

    private DigestAlgorithm(String algName, String OID) {
        this.algName = algName;
        this.OID = OID;
    }

    public static DigestAlgorithm fromString(String algorithmName, DigestAlgorithm defaultAlgorithm) {
        if (algorithmName == null || algorithmName.isEmpty()) {
            return defaultAlgorithm;
        }
        if (algorithmName.equalsIgnoreCase(SHA1.getAlgName())) {
            return SHA1;
        }
        if (algorithmName.equalsIgnoreCase(SHA256.getAlgName())) {
            return SHA256;
        }
        if (algorithmName.equalsIgnoreCase(SHA384.getAlgName())) {
            return SHA384;
        }
        if (algorithmName.equalsIgnoreCase(SHA512.getAlgName())) {
            return SHA512;
        }
        if (algorithmName.equalsIgnoreCase(MD5.getAlgName())) {
            return MD5;
        }
        return defaultAlgorithm;
    }

    public static DigestAlgorithm fromOID(String OID, DigestAlgorithm defaultAlgorithm) {
        if (StringUtils.isEmpty((String)OID)) {
            return defaultAlgorithm;
        }
        if (OID.equalsIgnoreCase(SHA1.getOID())) {
            return SHA1;
        }
        if (OID.equalsIgnoreCase(SHA256.getOID())) {
            return SHA256;
        }
        if (OID.equalsIgnoreCase(SHA384.getOID())) {
            return SHA384;
        }
        if (OID.equalsIgnoreCase(SHA512.getOID())) {
            return SHA512;
        }
        if (OID.equalsIgnoreCase(MD5.getOID())) {
            return MD5;
        }
        return defaultAlgorithm;
    }

    public String getOID() {
        return this.OID;
    }

    public String getAlgName() {
        return this.algName;
    }
}

