/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography.activekeyops;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.X509Certificate;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.cryptography.activekeyops.DirectSignedDataGenerator;

public class DefaultDirectSignedDataGenerator
implements DirectSignedDataGenerator {
    protected final CMSSignedDataGenerator generator;
    protected final String sigProvider;

    public DefaultDirectSignedDataGenerator(String sigProvider) {
        this.sigProvider = StringUtils.isEmpty((String)sigProvider) ? CryptoExtensions.getJCESensitiveProviderName() : sigProvider;
        this.generator = new CMSSignedDataGenerator();
    }

    @Override
    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        this.generator.addSigner(key, cert, digestOID, signedAttr, unsignedAttr);
    }

    @Override
    public void addCertificatesAndCRLs(CertStore certStore) throws CertStoreException, CMSException {
        this.generator.addCertificatesAndCRLs(certStore);
    }

    @Override
    public CMSSignedData generate(CMSProcessable content) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generator.generate(content, false, this.sigProvider);
    }
}

