/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy;

import java.util.Vector;
import org.nhindirect.policy.OperationPolicyExpression;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.policy.PolicyExpressionType;
import org.nhindirect.policy.PolicyOperator;

public class OperationPolicyExpressionFactory {
    public static OperationPolicyExpression getInstance(PolicyOperator operator, Vector<PolicyExpression> operands) {
        return new OperationPolicyExpressionImpl(operator, operands);
    }

    public static class OperationPolicyExpressionImpl
    implements OperationPolicyExpression {
        static final long serialVersionUID = -9131661511886002211L;
        protected final PolicyOperator operator;
        protected final Vector<PolicyExpression> operands;

        protected OperationPolicyExpressionImpl(PolicyOperator operator, Vector<PolicyExpression> operands) {
            this.operator = operator;
            this.operands = new Vector<PolicyExpression>(operands);
        }

        @Override
        public PolicyExpressionType getExpressionType() {
            return PolicyExpressionType.OPERATION;
        }

        @Override
        public PolicyOperator getPolicyOperator() {
            return this.operator;
        }

        @Override
        public Vector<PolicyExpression> getOperands() {
            return this.operands;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Operator: ").append(this.operator.toString());
            int i = 1;
            for (PolicyExpression operand : this.operands) {
                try {
                    builder.append("\r\nOperand ").append(i++).append(": ").append(operand.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return builder.toString();
        }
    }
}

