/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509Name;
import org.nhindirect.policy.PolicyProcessException;
import org.nhindirect.policy.PolicyValueFactory;
import org.nhindirect.policy.x509.IssuerAttributeField;
import org.nhindirect.policy.x509.RDNAttributeIdentifier;
import org.nhindirect.policy.x509.TBSFieldName;

public class SubjectAttributeField
extends IssuerAttributeField {
    static final long serialVersionUID = -6488771961800809924L;

    public SubjectAttributeField(boolean required, RDNAttributeIdentifier rdnAttributeId) {
        super(required, rdnAttributeId);
    }

    @Override
    public void injectReferenceValue(X509Certificate value) throws PolicyProcessException {
        this.certificate = value;
        if (this.rdnAttributeId.equals((Object)RDNAttributeIdentifier.DISTINGUISHED_NAME)) {
            List<String> str = Arrays.asList(this.certificate.getSubjectX500Principal().getName("RFC2253"));
            this.policyValue = PolicyValueFactory.getInstance(str);
            return;
        }
        super.injectReferenceValue(value);
    }

    @Override
    public TBSFieldName getFieldName() {
        return TBSFieldName.SUBJECT;
    }

    @Override
    protected X509Name getX509Name(TBSCertificateStructure tbsStruct) {
        return tbsStruct.getSubject();
    }
}

