/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.dns.DNSException;
import org.nhindirect.dns.DNSResponder;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSSocketServer;
import org.xbill.DNS.Message;

public class UDPServer
extends DNSSocketServer {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(UDPServer.class);
    private static final int MAX_WIRE_SIZE = 512;
    private DatagramSocket serverSock;
    private volatile long missCount = 0L;
    private volatile long errorCount = 0L;
    private volatile long successCount = 0L;

    public UDPServer(DNSServerSettings settings, DNSResponder responder) throws DNSException {
        super(settings, responder);
        this.registerMBean(this.getClass());
    }

    @Override
    public void start() throws DNSException {
        LOGGER.info((Object)"DNS UPD Server Starting");
        super.start();
        if (LOGGER.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("DNS UDP Server Startup Complete\r\n\tBind Address: ").append(this.settings.getBindAddress());
            builder.append("\r\n\tBind Port: ").append(this.settings.getPort());
            LOGGER.info((Object)builder.toString());
        }
    }

    @Override
    public void stop() throws DNSException {
        super.stop();
        this.serverSock.close();
        this.waitForGracefulStop();
    }

    @Override
    public void createServerSocket() throws DNSException {
        try {
            this.serverSock = new DatagramSocket(this.settings.getPort(), Inet4Address.getByName(this.settings.getBindAddress()));
            this.serverSock.setReceiveBufferSize(this.settings.getMaxRequestSize());
            this.serverSock.setSoTimeout(this.settings.getReceiveTimeout());
        }
        catch (Exception e) {
            throw new DNSException(null, "Failed to create UDP server socket: " + e.getMessage(), e);
        }
    }

    @Override
    public Runnable getSocketAcceptTask() {
        return new ReceiveTask();
    }

    @Override
    public Runnable getDNSRequestTask(Object packet) {
        return new RequestTask((DatagramPacket)packet);
    }

    private void reconnect() {
        this.serverSock.close();
        this.serverSock = null;
        while (this.serverSock == null && this.running.get()) {
            try {
                this.createServerSocket();
                LOGGER.error((Object)"DNS UDP server socket re-established");
            }
            catch (DNSException ex) {
                LOGGER.error((Object)"DNS UDP server socket failed to rebind.  Trying again in 5 seconds.");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public Long getMissedRequestCount() {
        return this.missCount;
    }

    @Override
    public Long getSuccessfulRequestCount() {
        return this.successCount;
    }

    @Override
    public Long getErrorRequestCount() {
        return this.errorCount;
    }

    public class RequestTask
    implements Runnable {
        private DatagramPacket inPacket;

        public RequestTask(DatagramPacket inPacket) {
            this.inPacket = inPacket;
        }

        @Override
        public void run() {
            Message query = null;
            Message response = null;
            DatagramPacket outPacket = null;
            try {
                block9: {
                    try {
                        query = UDPServer.this.responder.toMessage(this.inPacket.getData());
                        response = UDPServer.this.responder.processRequest(query);
                    }
                    catch (DNSException e) {
                        if (query == null) break block9;
                        response = UDPServer.this.responder.processError(query, e.getError());
                    }
                }
                if (response != null) {
                    if (response.getRcode() == 0 || response.getRcode() == 3) {
                        ++UDPServer.this.successCount;
                        if (response.getSectionArray(1).length == 0) {
                            ++UDPServer.this.missCount;
                        }
                    } else {
                        ++UDPServer.this.errorCount;
                    }
                    byte[] writeBytes = response.toWire(512);
                    outPacket = new DatagramPacket(writeBytes, writeBytes.length, this.inPacket.getAddress(), this.inPacket.getPort());
                    UDPServer.this.serverSock.send(outPacket);
                } else {
                    ++UDPServer.this.errorCount;
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)("Wire/connection protocol error handing DNS request: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private class ReceiveTask
    implements Runnable {
        private ReceiveTask() {
        }

        @Override
        public void run() {
            while (UDPServer.this.running.get()) {
                try {
                    byte[] inBuffer = new byte[UDPServer.this.settings.getMaxRequestSize()];
                    DatagramPacket inPacket = new DatagramPacket(inBuffer, inBuffer.length);
                    UDPServer.this.serverSock.receive(inPacket);
                    UDPServer.this.submitDNSRequest(inPacket);
                }
                catch (Throwable e) {
                    if (!UDPServer.this.serverSock.isClosed() || !UDPServer.this.running.get()) continue;
                    LOGGER.error((Object)("DNS UDP server socket dropped:" + e.getMessage()));
                    UDPServer.this.reconnect();
                }
            }
        }
    }
}

