/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.tools.printers;

import java.net.URL;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.nhind.config.Certificate;
import org.nhindirect.dns.DNSException;
import org.nhindirect.dns.tools.printers.AbstractRecordPrinter;
import org.nhindirect.dns.utils.CertUtils;
import org.nhindirect.stagent.cert.Thumbprint;

public class CertRecordPrinter
extends AbstractRecordPrinter<Certificate> {
    protected static final SimpleDateFormat dateFormatter;
    protected static final String CERT_NAME_COL = "Subject Name/URL";
    protected static final String RECORD_TYPE_COL = "Record Type";
    protected static final String PRIVATE_IND_COL = "Private Key";
    protected static final String TP_NAME_COL = "Thumbprint";
    protected static final String EXPIRES_COL = "Expires";
    protected static final Collection<AbstractRecordPrinter.ReportColumn> REPORT_COLS;

    public CertRecordPrinter() {
        super(150, REPORT_COLS);
    }

    @Override
    protected String getColumnValue(AbstractRecordPrinter.ReportColumn column, Certificate retCert) {
        String tpOrURL = null;
        boolean isURL = false;
        X509Certificate cert = null;
        try {
            cert = CertUtils.toX509Certificate(retCert.getData());
            tpOrURL = Thumbprint.toThumbprint((X509Certificate)cert).toString();
        }
        catch (DNSException e) {
            // empty catch block
        }
        if (tpOrURL == null) {
            try {
                tpOrURL = new String(retCert.getData());
                URL url = new URL(tpOrURL);
                isURL = true;
            }
            catch (Exception e) {
                return "";
            }
        }
        try {
            if (column.header.equals(CERT_NAME_COL)) {
                return retCert.getOwner();
            }
            if (column.header.equals(RECORD_TYPE_COL)) {
                return isURL ? "IPKIX" : "PKIX";
            }
            if (column.header.equals(TP_NAME_COL)) {
                return isURL ? tpOrURL : Thumbprint.toThumbprint((X509Certificate)cert).toString();
            }
            if (column.header.equals(EXPIRES_COL)) {
                return isURL ? "" : dateFormatter.format(cert.getNotAfter());
            }
            if (column.header.equals(PRIVATE_IND_COL)) {
                return retCert.isPrivateKey() ? "Y" : "N";
            }
            return super.getColumnValue(column, retCert);
        }
        catch (Exception e) {
            return "ERROR: " + e.getMessage();
        }
    }

    static {
        REPORT_COLS = new ArrayList<AbstractRecordPrinter.ReportColumn>();
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(CERT_NAME_COL, 55, "getCertificate"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(RECORD_TYPE_COL, 11, "getCertificate"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(PRIVATE_IND_COL, 12, "getCertificate"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(TP_NAME_COL, 55, "getCertificate"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(EXPIRES_COL, 15, "getCertificate"));
        dateFormatter = new SimpleDateFormat("MMM d yyyy", Locale.getDefault());
    }
}

