/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.nhindirect.dns.DNSException;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.cert.X509CertificateEx;

public class CertUtils {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(CertUtils.class);

    public static byte[] pkcs12ToStrippedPkcs12(byte[] bytes, String passphrase) throws DNSException {
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException("Pkcs byte stream cannot be null or empty.");
        }
        if (passphrase == null) {
            throw new IllegalArgumentException("Passphrase cannot be null.");
        }
        byte[] retVal = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream outStr = new ByteArrayOutputStream();
        try {
            KeyStore localKeyStore = KeyStore.getInstance("PKCS12", CryptoExtensions.getJCEProviderName());
            localKeyStore.load(bais, passphrase.toCharArray());
            Enumeration<String> aliases = localKeyStore.aliases();
            if (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                X509Certificate cert = (X509Certificate)localKeyStore.getCertificate(alias);
                Key key = localKeyStore.getKey(alias, "".toCharArray());
                if (key != null && key instanceof PrivateKey) {
                    char[] emptyPass = "".toCharArray();
                    localKeyStore.setKeyEntry("privCert", key, emptyPass, new Certificate[]{cert});
                    localKeyStore.store(outStr, emptyPass);
                    retVal = outStr.toByteArray();
                }
            }
        }
        catch (Exception e) {
            throw new DNSException("Failed to strip encryption for PKCS stream.");
        }
        finally {
            try {
                bais.close();
            }
            catch (Exception e) {}
            try {
                outStr.close();
            }
            catch (Exception e) {}
        }
        return retVal;
    }

    public static byte[] x509CertificateToBytes(X509Certificate cert) throws DNSException {
        if (cert instanceof X509CertificateEx) {
            ByteArrayOutputStream outStr = new ByteArrayOutputStream();
            try {
                KeyStore convertKeyStore = KeyStore.getInstance("PKCS12", CryptoExtensions.getJCEProviderName());
                convertKeyStore.load(null, null);
                char[] emptyPass = "".toCharArray();
                convertKeyStore.setKeyEntry("privCert", ((X509CertificateEx)cert).getPrivateKey(), emptyPass, new Certificate[]{cert});
                convertKeyStore.store(outStr, emptyPass);
                byte[] byArray = outStr.toByteArray();
                return byArray;
            }
            catch (Exception e) {
                throw new DNSException("Failed to convert certificate to a byte stream.");
            }
            finally {
                try {
                    outStr.close();
                }
                catch (Exception e) {}
            }
        }
        try {
            return cert.getEncoded();
        }
        catch (Exception e) {
            throw new DNSException("Failed to convert certificate to a byte stream.");
        }
    }

    public static X509Certificate toX509Certificate(byte[] data) throws DNSException {
        return CertUtils.toX509Certificate(data, "");
    }

    public static X509Certificate toX509Certificate(byte[] data, String passPhrase) throws DNSException {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Byte stream cannot be null or empty.");
        }
        if (passPhrase == null) {
            passPhrase = "";
        }
        X509Certificate retVal = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            try {
                KeyStore localKeyStore = KeyStore.getInstance("PKCS12", CryptoExtensions.getJCEProviderName());
                localKeyStore.load(bais, passPhrase.toCharArray());
                Enumeration<String> aliases = localKeyStore.aliases();
                if (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    X509Certificate cert = (X509Certificate)localKeyStore.getCertificate(alias);
                    Key key = localKeyStore.getKey(alias, passPhrase.toCharArray());
                    if (key != null && key instanceof PrivateKey) {
                        retVal = X509CertificateEx.fromX509Certificate((X509Certificate)cert, (PrivateKey)((PrivateKey)key));
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (retVal == null) {
                bais.reset();
                bais = new ByteArrayInputStream(data);
                retVal = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
            }
        }
        catch (Exception e) {
            throw new DNSException("Failed to convert byte stream to a certificate.");
        }
        finally {
            try {
                bais.close();
            }
            catch (IOException ex) {}
        }
        return retVal;
    }

    public static X509Certificate certFromFile(String certFile) {
        File theCertFile = new File(certFile);
        try {
            LOGGER.trace((Object)("Full path of cert file to load: " + theCertFile.getAbsolutePath()));
            return CertUtils.toX509Certificate(FileUtils.readFileToByteArray((File)theCertFile));
        }
        catch (Exception e) {
            LOGGER.error((Object)("Failed to load certificate from file " + theCertFile.getAbsolutePath()), (Throwable)e);
            return null;
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

