@REM ----------------------------------------------------------------------------
@REM  Copyright 2001-2006 The Apache Software Foundation.
@REM
@REM  Licensed under the Apache License, Version 2.0 (the "License");
@REM  you may not use this file except in compliance with the License.
@REM  You may obtain a copy of the License at
@REM
@REM       http://www.apache.org/licenses/LICENSE-2.0
@REM
@REM  Unless required by applicable law or agreed to in writing, software
@REM  distributed under the License is distributed on an "AS IS" BASIS,
@REM  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@REM  See the License for the specific language governing permissions and
@REM  limitations under the License.
@REM ----------------------------------------------------------------------------
@REM
@REM   Copyright (c) 2001-2006 The Apache Software Foundation.  All rights
@REM   reserved.

@echo off

set ERROR_CODE=0

:init
@REM Decide how to startup depending on the version of windows

@REM -- Win98ME
if NOT "%OS%"=="Windows_NT" goto Win9xArg

@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" @setlocal

@REM -- 4NT shell
if "%eval[2+2]" == "4" goto 4NTArgs

@REM -- Regular WinNT shell
set CMD_LINE_ARGS=%*
goto WinNTGetScriptDir

@REM The 4NT Shell from jp software
:4NTArgs
set CMD_LINE_ARGS=%$
goto WinNTGetScriptDir

:Win9xArg
@REM Slurp the command line arguments.  This loop allows for an unlimited number
@REM of arguments (up to the command line limit, anyway).
set CMD_LINE_ARGS=
:Win9xApp
if %1a==a goto Win9xGetScriptDir
set CMD_LINE_ARGS=%CMD_LINE_ARGS% %1
shift
goto Win9xApp

:Win9xGetScriptDir
set SAVEDIR=%CD%
%0\
cd %0\..\.. 
set BASEDIR=%CD%
cd %SAVEDIR%
set SAVE_DIR=
goto repoSetup

:WinNTGetScriptDir
set BASEDIR=%~dp0\..

:repoSetup


if "%JAVACMD%"=="" set JAVACMD=java

if "%REPO%"=="" set REPO=%BASEDIR%\lib

set CLASSPATH="%BASEDIR%"\etc;"%REPO%"\guice-2.0.jar;"%REPO%"\aopalliance-1.0.jar;"%REPO%"\commons-logging-1.1.1.jar;"%REPO%"\commons-io-1.4.jar;"%REPO%"\bcprov-jdk15-140.jar;"%REPO%"\dnsjava-2.0.8.jar;"%REPO%"\config-service-client-2.0.jar;"%REPO%"\axis-1.4.jar;"%REPO%"\commons-discovery-0.4.jar;"%REPO%"\jaxrpc-api-1.1.jar;"%REPO%"\saaj-api-1.3.jar;"%REPO%"\wsdl4j-1.6.2.jar;"%REPO%"\jackson-jaxrs-1.7.5.jar;"%REPO%"\jackson-core-asl-1.7.5.jar;"%REPO%"\jackson-mapper-asl-1.7.5.jar;"%REPO%"\config-model-1.1.jar;"%REPO%"\commons-collections-3.1.jar;"%REPO%"\enunciate-core-annotations-1.23.jar;"%REPO%"\jsr250-api-1.0.jar;"%REPO%"\direct-policy-1.0.jar;"%REPO%"\xstream-1.4.4.jar;"%REPO%"\xmlpull-1.1.3.1.jar;"%REPO%"\xpp3_min-1.1.4c.jar;"%REPO%"\mail-1.4.3.jar;"%REPO%"\commons-lang-2.5.jar;"%REPO%"\direct-common-2.0.jar;"%REPO%"\dsn-1.4.3.jar;"%REPO%"\activation-1.1.jar;"%REPO%"\jdom-1.1.jar;"%REPO%"\jsr311-api-1.1.1.jar;"%REPO%"\httpclient-4.1.1.jar;"%REPO%"\httpcore-4.1.jar;"%REPO%"\agent-2.1.jar;"%REPO%"\commons-codec-1.4.jar;"%REPO%"\bcmail-jdk15-140.jar;"%REPO%"\jcs-1.3.jar;"%REPO%"\concurrent-1.0.jar;"%REPO%"\dns-1.5.1.jar
goto endInit

@REM Reaching here means variables are defined and arguments have been captured
:endInit

%JAVACMD% %JAVA_OPTS% -Dorg.apache.commons.logging.Log=org.apache.commons.logging.impl.SimpleLog -Dorg.apache.commons.logging.simplelog.defaultlog=error -classpath %CLASSPATH_PREFIX%;%CLASSPATH% -Dapp.name="DNSMgmtConsole" -Dapp.repo="%REPO%" -Dapp.home="%BASEDIR%" -Dbasedir="%BASEDIR%" org.nhindirect.dns.tools.DNSManager %CMD_LINE_ARGS%
if %ERRORLEVEL% NEQ 0 goto error
goto end

:error
if "%OS%"=="Windows_NT" @endlocal
set ERROR_CODE=%ERRORLEVEL%

:end
@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" goto endNT

@REM For old DOS remove the set variables from ENV - we assume they were not set
@REM before we started - at least we don't leave any baggage around
set CMD_LINE_ARGS=
goto postExec

:endNT
@REM If error code is set to 1 then the endlocal was done already in :error.
if %ERROR_CODE% EQU 0 @endlocal


:postExec

if "%FORCE_EXIT_ON_ERROR%" == "on" (
  if %ERROR_CODE% NEQ 0 exit %ERROR_CODE%
)

exit /B %ERROR_CODE%
