/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns;

import java.net.URL;
import junit.framework.TestCase;
import org.nhind.config.CertPolicy;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.PolicyLexicon;
import org.nhindirect.dns.ConfigServiceDNSStore;
import org.nhindirect.dns.util.ConfigServiceRunner;

public class ConfigServiceDNSStore_configCertPolicyTest
extends TestCase {
    static final String VALID_POLICY = "(X509.TBS.EXTENSION.KeyUsage & 32) > 0";
    static final String INVALID_VALID_POLICY = "(X509.TBS.EXTENSION.KeyUsage4fds & | 32) > 0";
    protected ConfigurationServiceProxy proxy;

    public void setUp() {
        try {
            if (!ConfigServiceRunner.isServiceRunning()) {
                ConfigServiceRunner.startConfigService();
            }
            this.proxy = new ConfigurationServiceProxy(ConfigServiceRunner.getConfigServiceURL());
            this.cleanRecords();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void cleanRecords() throws Exception {
        CertPolicy[] pols = this.proxy.getPolicies();
        if (pols != null && pols.length > 0) {
            Long[] ids = new Long[pols.length];
            for (int i = 0; i < pols.length; ++i) {
                ids[i] = pols[i].getId();
            }
            this.proxy.deletePolicies(ids);
        }
        pols = this.proxy.getPolicies();
        ConfigServiceDNSStore_configCertPolicyTest.assertNull((Object)pols);
    }

    public void testConfigCertPolicy_noJVMParam_assertNoPolicyConfiged() throws Exception {
        ConfigServiceDNSStore store = new ConfigServiceDNSStore(new URL(ConfigServiceRunner.getConfigServiceURL()));
        ConfigServiceDNSStore_configCertPolicyTest.assertNull((Object)store.polExpression);
        ConfigServiceDNSStore_configCertPolicyTest.assertNull((Object)store.polFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConfigCertPolicy_policyDoesNotExists_assertNoPolicyConfiged() throws Exception {
        System.setProperty("org.nhindirect.dns.CertPolicyName", "NoPolicy");
        try {
            ConfigServiceDNSStore store = new ConfigServiceDNSStore(new URL(ConfigServiceRunner.getConfigServiceURL()));
            ConfigServiceDNSStore_configCertPolicyTest.assertNull((Object)store.polExpression);
            ConfigServiceDNSStore_configCertPolicyTest.assertNull((Object)store.polFilter);
        }
        finally {
            System.setProperty("org.nhindirect.dns.CertPolicyName", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConfigCertPolicy_invalidPolicy_assertNoPolicyConfiged() throws Exception {
        System.setProperty("org.nhindirect.dns.CertPolicyName", "InvalidPolicy");
        try {
            CertPolicy policy = new CertPolicy();
            policy.setLexicon(PolicyLexicon.SIMPLE_TEXT_V1);
            policy.setPolicyName("InvalidPolicy");
            policy.setPolicyData(INVALID_VALID_POLICY.getBytes());
            this.proxy.addPolicy(policy);
            ConfigServiceDNSStore store = new ConfigServiceDNSStore(new URL(ConfigServiceRunner.getConfigServiceURL()));
            ConfigServiceDNSStore_configCertPolicyTest.assertNull((Object)store.polExpression);
            ConfigServiceDNSStore_configCertPolicyTest.assertNull((Object)store.polFilter);
        }
        finally {
            System.setProperty("org.nhindirect.dns.CertPolicyName", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConfigCertPolicy_validPolicy_assertPolicyConfiged() throws Exception {
        System.setProperty("org.nhindirect.dns.CertPolicyName", "ValidPolicy");
        try {
            CertPolicy policy = new CertPolicy();
            policy.setLexicon(PolicyLexicon.SIMPLE_TEXT_V1);
            policy.setPolicyName("ValidPolicy");
            policy.setPolicyData(VALID_POLICY.getBytes());
            this.proxy.addPolicy(policy);
            ConfigServiceDNSStore store = new ConfigServiceDNSStore(new URL(ConfigServiceRunner.getConfigServiceURL()));
            ConfigServiceDNSStore_configCertPolicyTest.assertNotNull((Object)store.polExpression);
            ConfigServiceDNSStore_configCertPolicyTest.assertNotNull((Object)store.polFilter);
        }
        finally {
            System.setProperty("org.nhindirect.dns.CertPolicyName", "");
        }
    }
}

