/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.tools;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.mina.util.AvailablePortFinder;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.DnsRecord;
import org.nhindirect.dns.ConfigServiceDNSStore;
import org.nhindirect.dns.DNSServer;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSStore;
import org.nhindirect.dns.tools.DNSRecordCommands;
import org.nhindirect.dns.util.BaseTestPlan;
import org.nhindirect.dns.util.ConfigServiceRunner;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.WireParseException;

public class DNSRecordCommands_importRecords_Test
extends TestCase {
    public void testImportARecord_AssertRecordAdded() throws Exception {
        new TestPlan(){
            private String fileName = "src/test/resources/dnsrecords/example.domain.com.a";

            @Override
            protected File getRecordFileToImport() throws Exception {
                return new File(this.fileName);
            }

            @Override
            protected int getRecordTypeToImport() throws Exception {
                return 1;
            }

            @Override
            protected void doAssertions(List<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)1, (int)records.size());
                Record rec = this.fromFile(new File(this.fileName));
                Record checkRec = records.get(0);
                Assert.assertEquals((Object)checkRec, (Object)rec);
            }
        }.perform();
    }

    public void testImportMXRecord_AssertRecordAdded() throws Exception {
        new TestPlan(){
            private String fileName = "src/test/resources/dnsrecords/example.domain.com.mx";

            @Override
            protected File getRecordFileToImport() throws Exception {
                return new File(this.fileName);
            }

            @Override
            protected int getRecordTypeToImport() throws Exception {
                return 15;
            }

            @Override
            protected void doAssertions(List<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)1, (int)records.size());
                Record rec = this.fromFile(new File(this.fileName));
                Record checkRec = records.get(0);
                Assert.assertEquals((Object)checkRec, (Object)rec);
            }
        }.perform();
    }

    public void testImportSOARecord_AssertRecordAdded() throws Exception {
        new TestPlan(){
            private String fileName = "src/test/resources/dnsrecords/example.domain.com.soa";

            @Override
            protected File getRecordFileToImport() throws Exception {
                return new File(this.fileName);
            }

            @Override
            protected int getRecordTypeToImport() throws Exception {
                return 6;
            }

            @Override
            protected void doAssertions(List<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)1, (int)records.size());
                Record rec = this.fromFile(new File(this.fileName));
                Record checkRec = records.get(0);
                Assert.assertEquals((Object)checkRec, (Object)rec);
            }
        }.perform();
    }

    public void testImportRecord_fileNotFound_AssertException() throws Exception {
        new TestPlan(){
            private String fileName = "src/test/resources/dnsrecords/example.domain.com.bogus";

            @Override
            protected File getRecordFileToImport() throws Exception {
                return new File(this.fileName);
            }

            @Override
            protected int getRecordTypeToImport() throws Exception {
                return 6;
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertNotNull((Object)exception);
                Assert.assertTrue((boolean)(exception instanceof IllegalArgumentException));
            }

            @Override
            protected void doAssertions(List<Record> records) throws Exception {
            }
        }.perform();
    }

    public void testImportRecord_corruptRecordFile_AssertException() throws Exception {
        new TestPlan(){
            private String fileName = "src/test/resources/dnsrecords/example.domain.com.corrupt";

            @Override
            protected File getRecordFileToImport() throws Exception {
                return new File(this.fileName);
            }

            @Override
            protected int getRecordTypeToImport() throws Exception {
                return 6;
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertNotNull((Object)exception);
                Assert.assertTrue((boolean)(exception instanceof RuntimeException));
                Assert.assertNotNull((Object)exception.getCause());
                Assert.assertNotNull((Object)(exception.getCause() instanceof WireParseException));
            }

            @Override
            protected void doAssertions(List<Record> records) throws Exception {
            }
        }.perform();
    }

    public void testImportRecord_incorrectType_AssertException() throws Exception {
        new TestPlan(){
            private String fileName = "src/test/resources/dnsrecords/example.domain.com.a";

            @Override
            protected File getRecordFileToImport() throws Exception {
                return new File(this.fileName);
            }

            @Override
            protected int getRecordTypeToImport() throws Exception {
                return 15;
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertNotNull((Object)exception);
                Assert.assertTrue((boolean)(exception instanceof IllegalArgumentException));
            }

            @Override
            protected void doAssertions(List<Record> records) throws Exception {
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected int port;
        protected DNSServer server = null;
        protected ConfigurationServiceProxy proxy;
        protected DNSRecordCommands recordCommands;

        TestPlan() {
        }

        protected List<Record> getRecordsInStore(int type) throws Exception {
            List<Record> retVal;
            DnsRecord[] records = this.proxy.getDNSByType(type);
            if (records == null || records.length == 0) {
                retVal = Collections.emptyList();
            } else {
                retVal = new ArrayList<Record>();
                for (DnsRecord record : records) {
                    retVal.add(this.toRecord(record));
                }
            }
            return retVal;
        }

        protected Record toRecord(DnsRecord rec) throws Exception {
            return Record.newRecord((Name)Name.fromString((String)rec.getName()), (int)rec.getType(), (int)rec.getDclass(), (long)rec.getTtl(), (byte[])rec.getData());
        }

        protected Record fromFile(File file) throws Exception {
            return Record.fromWire((byte[])FileUtils.readFileToByteArray((File)file), (int)1);
        }

        @Override
        protected void setupMocks() throws Exception {
            if (!ConfigServiceRunner.isServiceRunning()) {
                ConfigServiceRunner.startConfigService();
            }
            this.proxy = new ConfigurationServiceProxy(ConfigServiceRunner.getConfigServiceURL());
            this.cleanRecords();
            this.port = AvailablePortFinder.getNextAvailable((int)1024);
            DNSServerSettings settings = new DNSServerSettings();
            settings.setPort(this.port);
            this.server = new DNSServer((DNSStore)new ConfigServiceDNSStore(new URL(ConfigServiceRunner.getConfigServiceURL())), settings);
            this.server.start();
        }

        @Override
        protected void tearDownMocks() throws Exception {
            if (this.server != null) {
                this.server.stop();
            }
        }

        @Override
        protected void performInner() throws Exception {
            this.recordCommands = new DNSRecordCommands(this.proxy);
            int type = this.getRecordTypeToImport();
            String[] fileToImport = new String[]{this.getRecordFileToImport().getAbsolutePath()};
            switch (type) {
                case 1: {
                    this.recordCommands.importAddress(fileToImport);
                    break;
                }
                case 15: {
                    this.recordCommands.mXImport(fileToImport);
                    break;
                }
                case 6: {
                    this.recordCommands.sOAImport(fileToImport);
                }
            }
            this.doAssertions(this.getRecordsInStore(type));
        }

        private void cleanRecords() throws Exception {
            DnsRecord[] rec = this.proxy.getDNSByType(255);
            if (rec != null && rec.length > 0) {
                this.proxy.removeDNS(rec);
            }
            rec = this.proxy.getDNSByType(255);
            Assert.assertNull((Object)rec);
        }

        protected abstract File getRecordFileToImport() throws Exception;

        protected abstract int getRecordTypeToImport() throws Exception;

        protected abstract void doAssertions(List<Record> var1) throws Exception;
    }
}

