/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.tools;

import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.axis.AxisFault;
import org.apache.mina.util.AvailablePortFinder;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.DnsRecord;
import org.nhindirect.dns.ConfigServiceDNSStore;
import org.nhindirect.dns.DNSServer;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSStore;
import org.nhindirect.dns.tools.DNSRecordCommands;
import org.nhindirect.dns.tools.DNSRecordPrinter;
import org.nhindirect.dns.tools.MockDNSRecordPrinter;
import org.nhindirect.dns.util.BaseTestPlan;
import org.nhindirect.dns.util.ConfigServiceRunner;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;

public class DNSRecordCommands_matchMXRecords_Test
extends TestCase {
    public void testMatchRecords_AssertAllRecordMatched() throws Exception {
        new TestPlan(){
            private List<Record> recordsToAdd;

            @Override
            protected List<Record> getRecordsToAdd() throws Exception {
                this.recordsToAdd = new ArrayList<Record>();
                this.recordsToAdd.add((Record)new MXRecord(Name.fromString((String)"example.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail1.example.domain.com.")));
                this.recordsToAdd.add((Record)new MXRecord(Name.fromString((String)"example.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail2.example.domain.com.")));
                return this.recordsToAdd;
            }

            @Override
            protected String getNameToMatch() throws Exception {
                return "example.domain.com";
            }

            @Override
            protected void doAssertions(List<Record> recordsMatched) throws Exception {
                Assert.assertNotNull(recordsMatched);
                Assert.assertEquals((int)2, (int)recordsMatched.size());
                for (Record record : this.recordsToAdd) {
                    int index = this.recordsToAdd.indexOf(record);
                    Assert.assertTrue((index > -1 ? 1 : 0) != 0);
                    Record checkRecord = this.recordsToAdd.get(index);
                    Assert.assertEquals((Object)record, (Object)checkRecord);
                }
            }
        }.perform();
    }

    public void testMatchRecords_mxRecordsOnly_AssertOnlyMXRecordMatched() throws Exception {
        new TestPlan(){
            private List<Record> recordsToAdd;
            private List<Record> expectedMatchedRecords;

            @Override
            protected List<Record> getRecordsToAdd() throws Exception {
                this.recordsToAdd = new ArrayList<Record>();
                this.expectedMatchedRecords = new ArrayList<Record>();
                MXRecord recToAdd = new MXRecord(Name.fromString((String)"example.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail1.example.domain.com."));
                this.recordsToAdd.add((Record)recToAdd);
                this.expectedMatchedRecords.add((Record)recToAdd);
                recToAdd = new MXRecord(Name.fromString((String)"example.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail2.example.domain.com."));
                this.recordsToAdd.add((Record)recToAdd);
                this.expectedMatchedRecords.add((Record)recToAdd);
                this.recordsToAdd.add((Record)new ARecord(Name.fromString((String)"example.domain.com."), 1, 3600L, InetAddress.getByName("127.0.0.1")));
                return this.recordsToAdd;
            }

            @Override
            protected String getNameToMatch() throws Exception {
                return "example.domain.com";
            }

            @Override
            protected void doAssertions(List<Record> recordsMatched) throws Exception {
                Assert.assertNotNull(recordsMatched);
                Assert.assertEquals((int)2, (int)recordsMatched.size());
                for (Record record : this.expectedMatchedRecords) {
                    int index = this.recordsToAdd.indexOf(record);
                    Assert.assertTrue((index > -1 ? 1 : 0) != 0);
                    Record checkRecord = this.recordsToAdd.get(index);
                    Assert.assertEquals((Object)record, (Object)checkRecord);
                }
            }
        }.perform();
    }

    public void testMatchRecords_specificDomain_AssertOnlyDomainRecordMatched() throws Exception {
        new TestPlan(){
            private List<Record> recordsToAdd;
            private List<Record> expectedMatchedRecords;

            @Override
            protected List<Record> getRecordsToAdd() throws Exception {
                this.recordsToAdd = new ArrayList<Record>();
                this.expectedMatchedRecords = new ArrayList<Record>();
                MXRecord recToAdd = new MXRecord(Name.fromString((String)"example.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail1.example.domain.com."));
                this.recordsToAdd.add((Record)recToAdd);
                this.expectedMatchedRecords.add((Record)recToAdd);
                recToAdd = new MXRecord(Name.fromString((String)"example.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail2.example.domain.com."));
                this.recordsToAdd.add((Record)recToAdd);
                this.expectedMatchedRecords.add((Record)recToAdd);
                this.recordsToAdd.add((Record)new MXRecord(Name.fromString((String)"example2.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail1.example2.domain.com.")));
                return this.recordsToAdd;
            }

            @Override
            protected String getNameToMatch() throws Exception {
                return "example.domain.com";
            }

            @Override
            protected void doAssertions(List<Record> recordsMatched) throws Exception {
                Assert.assertNotNull(recordsMatched);
                Assert.assertEquals((int)2, (int)recordsMatched.size());
                for (Record record : this.expectedMatchedRecords) {
                    int index = this.recordsToAdd.indexOf(record);
                    Assert.assertTrue((index > -1 ? 1 : 0) != 0);
                    Record checkRecord = this.recordsToAdd.get(index);
                    Assert.assertEquals((Object)record, (Object)checkRecord);
                }
            }
        }.perform();
    }

    public void testMatchNoRecords_matchingParentDomain_AssertNoRecordMatched() throws Exception {
        new TestPlan(){
            private List<Record> recordsToAdd;

            @Override
            protected List<Record> getRecordsToAdd() throws Exception {
                this.recordsToAdd = new ArrayList<Record>();
                this.recordsToAdd.add((Record)new MXRecord(Name.fromString((String)"example.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail1.example.domain.com.")));
                this.recordsToAdd.add((Record)new MXRecord(Name.fromString((String)"example.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail2.example.domain.com.")));
                return this.recordsToAdd;
            }

            @Override
            protected String getNameToMatch() throws Exception {
                return "domain.com";
            }

            @Override
            protected void doAssertions(List<Record> recordsMatched) throws Exception {
                Assert.assertNotNull(recordsMatched);
                Assert.assertEquals((int)0, (int)recordsMatched.size());
            }
        }.perform();
    }

    public void testFailureToMatch_invalidProxy_AssertException() throws Exception {
        new TestPlan(){

            @Override
            protected List<Record> getRecordsToAdd() throws Exception {
                ArrayList<Record> recordsToAdd = new ArrayList<Record>();
                recordsToAdd.add((Record)new MXRecord(Name.fromString((String)"example.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail1.example.domain.com.")));
                return recordsToAdd;
            }

            @Override
            protected String getNameToMatch() throws Exception {
                this.recordCommands.setConfigurationProxy(new ConfigurationServiceProxy("http://localhost:7777/bogusendpoint"));
                return "example.domain.com";
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertNotNull((Object)exception);
                Assert.assertTrue((boolean)(exception instanceof RuntimeException));
                Assert.assertTrue((boolean)(exception.getCause() instanceof AxisFault));
            }

            @Override
            protected void doAssertions(List<Record> recordsMatched) throws Exception {
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected MockDNSRecordPrinter recordPrinter;
        protected int port;
        protected DNSServer server = null;
        protected ConfigurationServiceProxy proxy;
        protected DNSRecordCommands recordCommands;

        TestPlan() {
        }

        protected Record toRecord(DnsRecord rec) throws Exception {
            return Record.newRecord((Name)Name.fromString((String)rec.getName()), (int)rec.getType(), (int)rec.getDclass(), (long)rec.getTtl(), (byte[])rec.getData());
        }

        protected DnsRecord fromRecord(Record rec) throws Exception {
            DnsRecord newRec = new DnsRecord();
            newRec.setData(rec.rdataToWireCanonical());
            newRec.setDclass(rec.getDClass());
            newRec.setName(rec.getName().toString());
            newRec.setTtl(rec.getTTL());
            newRec.setType(rec.getType());
            return newRec;
        }

        @Override
        protected void setupMocks() throws Exception {
            if (!ConfigServiceRunner.isServiceRunning()) {
                ConfigServiceRunner.startConfigService();
            }
            this.proxy = new ConfigurationServiceProxy(ConfigServiceRunner.getConfigServiceURL());
            this.cleanRecords();
            this.port = AvailablePortFinder.getNextAvailable((int)1024);
            DNSServerSettings settings = new DNSServerSettings();
            settings.setPort(this.port);
            this.server = new DNSServer((DNSStore)new ConfigServiceDNSStore(new URL(ConfigServiceRunner.getConfigServiceURL())), settings);
            this.server.start();
            this.recordPrinter = new MockDNSRecordPrinter();
        }

        @Override
        protected void tearDownMocks() throws Exception {
            if (this.server != null) {
                this.server.stop();
            }
        }

        @Override
        protected void performInner() throws Exception {
            this.recordCommands = new DNSRecordCommands(this.proxy);
            this.recordCommands.setRecordPrinter((DNSRecordPrinter)this.recordPrinter);
            List<Record> recordsToAdd = this.getRecordsToAdd();
            DnsRecord[] addRecs = new DnsRecord[recordsToAdd.size()];
            int cnt = 0;
            for (Record recordToAdd : recordsToAdd) {
                addRecs[cnt++] = this.fromRecord(recordToAdd);
            }
            this.proxy.addDNS(addRecs);
            String matchName = this.getNameToMatch();
            this.recordCommands.matchMX(new String[]{matchName});
            ArrayList<Record> matchedRecords = new ArrayList<Record>();
            for (DnsRecord matchedRecord : this.recordPrinter.printedRecords) {
                matchedRecords.add(this.toRecord(matchedRecord));
            }
            this.doAssertions(matchedRecords);
        }

        private void cleanRecords() throws Exception {
            DnsRecord[] rec = this.proxy.getDNSByType(255);
            if (rec != null && rec.length > 0) {
                this.proxy.removeDNS(rec);
            }
            rec = this.proxy.getDNSByType(255);
            Assert.assertNull((Object)rec);
        }

        protected abstract List<Record> getRecordsToAdd() throws Exception;

        protected abstract String getNameToMatch() throws Exception;

        protected abstract void doAssertions(List<Record> var1) throws Exception;
    }
}

