/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.util;

import org.apache.mina.util.AvailablePortFinder;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.webapp.WebAppContext;

public class ConfigServiceRunner {
    private static Server server;
    private static int HTTPPort;
    private static String configServiceURL;

    public static synchronized void startConfigService() throws Exception {
        if (server == null) {
            server = new Server();
            SocketConnector connector = new SocketConnector();
            HTTPPort = AvailablePortFinder.getNextAvailable((int)1024);
            connector.setPort(HTTPPort);
            WebAppContext context = new WebAppContext();
            context.setContextPath("/config");
            context.setServer(server);
            context.setWar("war/config-service.war");
            server.setSendServerVersion(false);
            server.addConnector((Connector)connector);
            server.addHandler((Handler)context);
            server.start();
            configServiceURL = "http://localhost:" + HTTPPort + "/config/ConfigurationService";
        }
    }

    public static synchronized boolean isServiceRunning() {
        return server != null && server.isRunning();
    }

    public static synchronized void shutDownConfigService() throws Exception {
        if (ConfigServiceRunner.isServiceRunning()) {
            server.stop();
            server = null;
        }
    }

    public static synchronized String getConfigServiceURL() {
        return configServiceURL;
    }
}

