/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns;

import java.net.URL;
import java.security.cert.X509Certificate;
import junit.framework.TestCase;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.nhind.config.CertPolicy;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.PolicyLexicon;
import org.nhindirect.dns.ConfigServiceDNSStore;
import org.nhindirect.dns.util.ConfigServiceRunner;
import org.nhindirect.dns.util.DNSRecordUtil;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.policy.PolicyFilter;

public class ConfigServiceDNSStore_isCertCompliantWithPolicyTest
extends TestCase {
    static final String KEY_ENC_POLICY = "(X509.TBS.EXTENSION.KeyUsage & 32) > 0";
    protected ConfigurationServiceProxy proxy;

    public void setUp() {
        try {
            if (!ConfigServiceRunner.isServiceRunning()) {
                ConfigServiceRunner.startConfigService();
            }
            this.proxy = new ConfigurationServiceProxy(ConfigServiceRunner.getConfigServiceURL());
            this.cleanRecords();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void cleanRecords() throws Exception {
        CertPolicy[] pols = this.proxy.getPolicies();
        if (pols != null && pols.length > 0) {
            Long[] ids = new Long[pols.length];
            for (int i = 0; i < pols.length; ++i) {
                ids[i] = pols[i].getId();
            }
            this.proxy.deletePolicies(ids);
        }
        pols = this.proxy.getPolicies();
        ConfigServiceDNSStore_isCertCompliantWithPolicyTest.assertNull((Object)pols);
    }

    public void testisCertCompliantWithPolicy_noPolicyConfigured_assertCompliant() throws Exception {
        ConfigServiceDNSStore store = new ConfigServiceDNSStore(new URL(ConfigServiceRunner.getConfigServiceURL()));
        ConfigServiceDNSStore_isCertCompliantWithPolicyTest.assertNull((Object)store.polExpression);
        ConfigServiceDNSStore_isCertCompliantWithPolicyTest.assertNull((Object)store.polFilter);
        X509Certificate cert = DNSRecordUtil.loadCertificate("bob.der");
        ConfigServiceDNSStore_isCertCompliantWithPolicyTest.assertTrue((boolean)store.isCertCompliantWithPolicy(cert));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testisCertCompliantWithPolicy_policyConfigured_compliantCert_assertCompliant() throws Exception {
        System.setProperty("org.nhindirect.dns.CertPolicyName", "ValidPolicy");
        try {
            CertPolicy policy = new CertPolicy();
            policy.setLexicon(PolicyLexicon.SIMPLE_TEXT_V1);
            policy.setPolicyName("ValidPolicy");
            policy.setPolicyData(KEY_ENC_POLICY.getBytes());
            this.proxy.addPolicy(policy);
            ConfigServiceDNSStore store = new ConfigServiceDNSStore(new URL(ConfigServiceRunner.getConfigServiceURL()));
            ConfigServiceDNSStore_isCertCompliantWithPolicyTest.assertNotNull((Object)store.polExpression);
            ConfigServiceDNSStore_isCertCompliantWithPolicyTest.assertNotNull((Object)store.polFilter);
            X509Certificate cert = DNSRecordUtil.loadCertificate("bob.der");
            ConfigServiceDNSStore_isCertCompliantWithPolicyTest.assertTrue((boolean)store.isCertCompliantWithPolicy(cert));
        }
        finally {
            System.setProperty("org.nhindirect.dns.CertPolicyName", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testisCertCompliantWithPolicy_policyConfigured_nonCompliantCert_assertNonCompliant() throws Exception {
        System.setProperty("org.nhindirect.dns.CertPolicyName", "ValidPolicy");
        try {
            CertPolicy policy = new CertPolicy();
            policy.setLexicon(PolicyLexicon.SIMPLE_TEXT_V1);
            policy.setPolicyName("ValidPolicy");
            policy.setPolicyData(KEY_ENC_POLICY.getBytes());
            this.proxy.addPolicy(policy);
            ConfigServiceDNSStore store = new ConfigServiceDNSStore(new URL(ConfigServiceRunner.getConfigServiceURL()));
            ConfigServiceDNSStore_isCertCompliantWithPolicyTest.assertNotNull((Object)store.polExpression);
            ConfigServiceDNSStore_isCertCompliantWithPolicyTest.assertNotNull((Object)store.polFilter);
            X509Certificate cert = DNSRecordUtil.loadCertificate("umesh.der");
            ConfigServiceDNSStore_isCertCompliantWithPolicyTest.assertFalse((boolean)store.isCertCompliantWithPolicy(cert));
        }
        finally {
            System.setProperty("org.nhindirect.dns.CertPolicyName", "");
        }
    }

    public void testisCertCompliantWithPolicy_exceptionInFilter_assertCompliant() throws Exception {
        ConfigServiceDNSStore store = new ConfigServiceDNSStore(new URL(ConfigServiceRunner.getConfigServiceURL()));
        PolicyFilter filt = (PolicyFilter)Mockito.mock(PolicyFilter.class);
        ((PolicyFilter)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)filt)).isCompliant((X509Certificate)Matchers.any(), (PolicyExpression)Matchers.any());
        store.polFilter = filt;
        X509Certificate cert = DNSRecordUtil.loadCertificate("umesh.der");
        ConfigServiceDNSStore_isCertCompliantWithPolicyTest.assertTrue((boolean)store.isCertCompliantWithPolicy(cert));
    }
}

