/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.tools;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.mina.util.AvailablePortFinder;
import org.nhind.config.Certificate;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.DnsRecord;
import org.nhindirect.dns.ConfigServiceDNSStore;
import org.nhindirect.dns.DNSServer;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSStore;
import org.nhindirect.dns.tools.CertCommands;
import org.nhindirect.dns.tools.CertRecordCounterPrinter;
import org.nhindirect.dns.tools.printers.RecordPrinter;
import org.nhindirect.dns.util.BaseTestPlan;
import org.nhindirect.dns.util.ConfigServiceRunner;

public class CertCommands_importPrivateCert_Test
extends TestCase {
    public void testImportPrivateCert_importFromFile_nullPassphrash_AssertRecordImported() throws Exception {
        new TestPlan(){

            @Override
            protected Map<String, String> getCertFilesToAdd() throws Exception {
                HashMap<String, String> retCerts = new HashMap<String, String>();
                retCerts.put("./src/test/resources/certs/certCheckA.p12", null);
                return retCerts;
            }

            @Override
            protected void doAssertions(Certificate[] importedCerts) throws Exception {
                Assert.assertEquals((int)1, (int)importedCerts.length);
                Certificate cert = importedCerts[0];
                Assert.assertEquals((String)"certCheckA@sigCheck.com", (String)cert.getOwner());
                Assert.assertTrue((boolean)cert.isPrivateKey());
            }
        }.perform();
    }

    public void testImportPrivateCert_importFromFile_emptyPassphrash_AssertRecordImported() throws Exception {
        new TestPlan(){

            @Override
            protected Map<String, String> getCertFilesToAdd() throws Exception {
                HashMap<String, String> retCerts = new HashMap<String, String>();
                retCerts.put("./src/test/resources/certs/certCheckA.p12", "");
                return retCerts;
            }

            @Override
            protected void doAssertions(Certificate[] importedCerts) throws Exception {
                Assert.assertEquals((int)1, (int)importedCerts.length);
                Certificate cert = importedCerts[0];
                Assert.assertEquals((String)"certCheckA@sigCheck.com", (String)cert.getOwner());
                Assert.assertTrue((boolean)cert.isPrivateKey());
            }
        }.perform();
    }

    public void testImportPrivateCert_importFromFile_invalidPassphrash_AssertRecordNotImported() throws Exception {
        new TestPlan(){

            @Override
            protected Map<String, String> getCertFilesToAdd() throws Exception {
                HashMap<String, String> retCerts = new HashMap<String, String>();
                retCerts.put("./src/test/resources/certs/certCheckA.p12", "invalid");
                return retCerts;
            }

            @Override
            protected void doAssertions(Certificate[] importedCerts) throws Exception {
                Assert.assertNull((Object)importedCerts);
            }
        }.perform();
    }

    public void testImportPrivateCert_fileDoesNotExist__AssertRecordNotImported() throws Exception {
        new TestPlan(){

            @Override
            protected Map<String, String> getCertFilesToAdd() throws Exception {
                HashMap<String, String> retCerts = new HashMap<String, String>();
                retCerts.put("./src/test/resources/certs/gm2552doesnotexist.der", "");
                return retCerts;
            }

            @Override
            protected void doAssertions(Certificate[] importedCerts) throws Exception {
                Assert.assertNull((Object)importedCerts);
            }
        }.perform();
    }

    public void testImportPrivateCert_invalidProxy__AssertRecordNotImported() throws Exception {
        new TestPlan(){

            @Override
            protected void setupMocks() throws Exception {
                super.setupMocks();
                this.proxy = new ConfigurationServiceProxy("http://boGussite.cdm");
                this.certCommands.setConfigurationProxy(this.proxy);
            }

            @Override
            protected Map<String, String> getCertFilesToAdd() throws Exception {
                HashMap<String, String> retCerts = new HashMap<String, String>();
                retCerts.put("./src/test/resources/certs/certCheckA@sigCheck.com", "");
                return retCerts;
            }

            @Override
            protected void doAssertions(Certificate[] importedCerts) throws Exception {
                Assert.assertNull((Object)importedCerts);
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected CertRecordCounterPrinter recordPrinter;
        protected int port;
        protected DNSServer server = null;
        protected ConfigurationServiceProxy proxy;
        protected CertCommands certCommands;

        TestPlan() {
        }

        @Override
        protected void setupMocks() throws Exception {
            if (!ConfigServiceRunner.isServiceRunning()) {
                ConfigServiceRunner.startConfigService();
            }
            this.proxy = new ConfigurationServiceProxy(ConfigServiceRunner.getConfigServiceURL());
            this.cleanRecords();
            this.port = AvailablePortFinder.getNextAvailable((int)1024);
            DNSServerSettings settings = new DNSServerSettings();
            settings.setPort(this.port);
            this.server = new DNSServer((DNSStore)new ConfigServiceDNSStore(new URL(ConfigServiceRunner.getConfigServiceURL())), settings);
            this.server.start();
            this.recordPrinter = new CertRecordCounterPrinter();
            this.certCommands = new CertCommands(this.proxy);
            this.certCommands.setRecordPrinter((RecordPrinter)this.recordPrinter);
        }

        @Override
        protected void tearDownMocks() throws Exception {
            if (this.server != null) {
                this.server.stop();
            }
        }

        private void cleanRecords() throws Exception {
            DnsRecord[] rec = this.proxy.getDNSByType(255);
            if (rec != null && rec.length > 0) {
                this.proxy.removeDNS(rec);
            }
            rec = this.proxy.getDNSByType(255);
            Assert.assertNull((Object)rec);
            Certificate[] certs = this.proxy.listCertificates(0L, 1000, null);
            if (certs != null && certs.length > 0) {
                long[] ids = new long[certs.length];
                int idx = 0;
                for (Certificate cert : certs) {
                    ids[idx++] = cert.getId();
                }
                this.proxy.removeCertificates(ids);
            }
        }

        @Override
        protected void performInner() throws Exception {
            Map<String, String> certsToAdd = this.getCertFilesToAdd();
            if (certsToAdd.size() > 0) {
                for (Map.Entry<String, String> certToAdd : certsToAdd.entrySet()) {
                    String[] stringArray;
                    if (certToAdd.getValue() != null) {
                        String[] stringArray2 = new String[2];
                        stringArray2[0] = certToAdd.getKey();
                        stringArray = stringArray2;
                        stringArray2[1] = certToAdd.getValue();
                    } else {
                        String[] stringArray3 = new String[1];
                        stringArray = stringArray3;
                        stringArray3[0] = certToAdd.getKey();
                    }
                    String[] args = stringArray;
                    this.certCommands.importPrivateCert(args);
                }
            }
            Certificate[] importedCerts = null;
            try {
                importedCerts = this.proxy.listCertificates(0L, 100, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.doAssertions(importedCerts);
        }

        protected abstract Map<String, String> getCertFilesToAdd() throws Exception;

        protected abstract void doAssertions(Certificate[] var1) throws Exception;
    }
}

