/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.tools;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.mina.util.AvailablePortFinder;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.DnsRecord;
import org.nhindirect.dns.ConfigServiceDNSStore;
import org.nhindirect.dns.DNSServer;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSStore;
import org.nhindirect.dns.tools.DNSRecordCommands;
import org.nhindirect.dns.util.BaseTestPlan;
import org.nhindirect.dns.util.ConfigServiceRunner;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;

public class DNSRecordCommands_addSAORecords_Test
extends TestCase {
    public void testAddSOA_AssertRecordAdded() throws Exception {
        new TestPlan(){
            private Record addRecord;

            @Override
            protected List<Record> getRecordsToAdd() throws Exception {
                ArrayList<Record> addRecords = new ArrayList<Record>();
                this.addRecord = new SOARecord(Name.fromString((String)"example.domain.com."), 1, 3600L, Name.fromString((String)"ns1.example.domain.com."), Name.fromString((String)"gm2552.example.domain.com."), 1L, 3600L, 60L, 60L, 3600L);
                addRecords.add(this.addRecord);
                return addRecords;
            }

            @Override
            protected void doAssertions(List<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)1, (int)records.size());
                Record rec = records.iterator().next();
                Assert.assertEquals((Object)this.addRecord, (Object)rec);
            }
        }.perform();
    }

    public void testAddDupSOA_AssertOneEntry() throws Exception {
        new TestPlan(){
            private Record addRecord;

            @Override
            protected List<Record> getRecordsToAdd() throws Exception {
                ArrayList<Record> addRecords = new ArrayList<Record>();
                this.addRecord = new SOARecord(Name.fromString((String)"example.domain.com."), 1, 3600L, Name.fromString((String)"ns1.example.domain.com."), Name.fromString((String)"gm2552.example.domain.com."), 1L, 3600L, 60L, 60L, 3600L);
                addRecords.add(this.addRecord);
                addRecords.add((Record)new SOARecord(Name.fromString((String)"example.domain.com."), 1, 3600L, Name.fromString((String)"ns1.example.domain.com."), Name.fromString((String)"gm2552.example.domain.com."), 1L, 3600L, 60L, 60L, 3600L));
                return addRecords;
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertTrue((boolean)(exception instanceof RuntimeException));
                Assert.assertNotNull((Object)exception.getCause());
                Assert.assertTrue((boolean)(exception.getCause() instanceof RemoteException));
                List<Record> records = this.getSOARecordsInStore();
                Assert.assertNotNull(records);
                Assert.assertEquals((int)1, (int)records.size());
                Record rec = (Record)records.iterator().next();
                Assert.assertEquals((Object)this.addRecord, (Object)rec);
            }

            @Override
            protected void doAssertions(List<Record> records) throws Exception {
            }
        }.perform();
    }

    public void testAddMultipleSOARecords_AssertRecordsAdded() throws Exception {
        new TestPlan(){
            private List<Record> addRecords;

            @Override
            protected List<Record> getRecordsToAdd() throws Exception {
                this.addRecords = new ArrayList<Record>();
                this.addRecords.add((Record)new SOARecord(Name.fromString((String)"example.domain.com."), 1, 3600L, Name.fromString((String)"ns1.example.domain.com."), Name.fromString((String)"gm2552.example.domain.com."), 1L, 3600L, 60L, 60L, 3600L));
                this.addRecords.add((Record)new SOARecord(Name.fromString((String)"example2.domain.com."), 1, 3600L, Name.fromString((String)"ns1.example2.domain.com."), Name.fromString((String)"gm2552.example2.domain.com."), 1L, 3600L, 60L, 60L, 3600L));
                this.addRecords.add((Record)new SOARecord(Name.fromString((String)"example3.domain.com."), 1, 3600L, Name.fromString((String)"ns1.example3.domain.com."), Name.fromString((String)"gm2552.example3.domain.com."), 1L, 3600L, 60L, 60L, 3600L));
                return this.addRecords;
            }

            @Override
            protected void doAssertions(List<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)3, (int)records.size());
                for (Record record : this.addRecords) {
                    int index = records.indexOf(record);
                    Assert.assertTrue((index > -1 ? 1 : 0) != 0);
                    Record checkRecord = records.get(index);
                    Assert.assertEquals((Object)record, (Object)checkRecord);
                }
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected int port;
        protected DNSServer server = null;
        protected ConfigurationServiceProxy proxy;
        protected DNSRecordCommands recordCommands;

        TestPlan() {
        }

        protected Record toRecord(DnsRecord rec) throws Exception {
            return Record.newRecord((Name)Name.fromString((String)rec.getName()), (int)rec.getType(), (int)rec.getDclass(), (long)rec.getTtl(), (byte[])rec.getData());
        }

        protected List<Record> getSOARecordsInStore() throws Exception {
            List<Record> retVal;
            DnsRecord[] records = this.proxy.getDNSByType(6);
            if (records == null || records.length == 0) {
                retVal = Collections.emptyList();
            } else {
                retVal = new ArrayList<Record>();
                for (DnsRecord record : records) {
                    retVal.add(this.toRecord(record));
                }
            }
            return retVal;
        }

        @Override
        protected void setupMocks() throws Exception {
            if (!ConfigServiceRunner.isServiceRunning()) {
                ConfigServiceRunner.startConfigService();
            }
            this.proxy = new ConfigurationServiceProxy(ConfigServiceRunner.getConfigServiceURL());
            this.cleanRecords();
            this.port = AvailablePortFinder.getNextAvailable((int)1024);
            DNSServerSettings settings = new DNSServerSettings();
            settings.setPort(this.port);
            this.server = new DNSServer((DNSStore)new ConfigServiceDNSStore(new URL(ConfigServiceRunner.getConfigServiceURL())), settings);
            this.server.start();
        }

        @Override
        protected void tearDownMocks() throws Exception {
            if (this.server != null) {
                this.server.stop();
            }
        }

        @Override
        protected void performInner() throws Exception {
            this.recordCommands = new DNSRecordCommands(this.proxy);
            List<Record> recordsToAdd = this.getRecordsToAdd();
            for (Record recordToAdd : recordsToAdd) {
                SOARecord rec = (SOARecord)recordToAdd;
                String[] command = new String[]{rec.getName().toString(), rec.getHost().toString(), rec.getAdmin().toString(), Long.toString(rec.getSerial()), Long.toString(rec.getTTL()), Long.toString(rec.getRefresh()), Long.toString(rec.getRetry()), Long.toString(rec.getExpire()), Long.toString(rec.getMinimum())};
                this.recordCommands.addSOA(command);
            }
            this.doAssertions(this.getSOARecordsInStore());
        }

        private void cleanRecords() throws Exception {
            DnsRecord[] rec = this.proxy.getDNSByType(255);
            if (rec != null && rec.length > 0) {
                this.proxy.removeDNS(rec);
            }
            rec = this.proxy.getDNSByType(255);
            Assert.assertNull((Object)rec);
        }

        protected abstract List<Record> getRecordsToAdd() throws Exception;

        protected abstract void doAssertions(List<Record> var1) throws Exception;
    }
}

