/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns;

import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhind.config.CertPolicy;
import org.nhind.config.Certificate;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.DnsRecord;
import org.nhindirect.config.model.exceptions.CertificateConversionException;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.dns.AbstractDNSStore;
import org.nhindirect.dns.DNSError;
import org.nhindirect.dns.DNSException;
import org.nhindirect.dns.annotation.ConfigServiceURL;
import org.nhindirect.policy.PolicyFilterFactory;
import org.nhindirect.policy.PolicyLexicon;
import org.nhindirect.policy.PolicyLexiconParser;
import org.nhindirect.policy.PolicyLexiconParserFactory;
import org.nhindirect.policy.x509.SignatureAlgorithmIdentifier;
import org.xbill.DNS.CERTRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;

public class ConfigServiceDNSStore
extends AbstractDNSStore {
    protected static final Log LOGGER = LogFactory.getFactory().getInstance(ConfigServiceDNSStore.class);
    final ConfigurationServiceProxy proxy;

    @Inject
    public ConfigServiceDNSStore(@ConfigServiceURL URL serviceURL) {
        this.proxy = new ConfigurationServiceProxy(serviceURL.toString());
        try {
            this.configCertPolicy();
        }
        catch (DNSException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configCertPolicy() throws DNSException {
        block7: {
            block8: {
                String polName = System.getProperty("org.nhindirect.dns.CertPolicyName");
                if (StringUtils.isEmpty((String)polName)) break block8;
                ByteArrayInputStream inStream = null;
                LOGGER.info((Object)("Certificate policy name " + polName + " has been configured."));
                try {
                    CertPolicy policy = this.proxy.getPolicyByName(polName);
                    if (policy == null) {
                        LOGGER.warn((Object)("Certificate policy " + polName + " could not be found in the system.  Falling back to no policy."));
                        IOUtils.closeQuietly((InputStream)inStream);
                        return;
                    }
                    PolicyLexiconParser parser = PolicyLexiconParserFactory.getInstance((PolicyLexicon)PolicyLexicon.valueOf((String)policy.getLexicon().getValue()));
                    inStream = new ByteArrayInputStream(policy.getPolicyData());
                    this.polExpression = parser.parse((InputStream)inStream);
                    this.polFilter = PolicyFilterFactory.getInstance();
                    IOUtils.closeQuietly((InputStream)inStream);
                }
                catch (Exception e) {
                    LOGGER.warn((Object)("Error loading and compling certificate policy " + polName + ".  Will fallback to no policy filter."), (Throwable)e);
                    break block7;
                }
                finally {
                    IOUtils.closeQuietly(inStream);
                }
                break block7;
            }
            LOGGER.info((Object)"No certificate policy has been configured.");
        }
    }

    @Override
    protected RRset processGenericRecordRequest(String name, int type) throws DNSException {
        DnsRecord[] records;
        try {
            records = this.proxy.getDNSByNameAndType(name, type);
        }
        catch (Exception e) {
            throw new DNSException(DNSError.newError(2), "DNS service proxy call for DNS records failed: " + e.getMessage(), e);
        }
        if (records == null || records.length == 0) {
            return null;
        }
        RRset retVal = new RRset();
        try {
            for (DnsRecord record : records) {
                Record rec = Record.newRecord((Name)Name.fromString((String)record.getName()), (int)record.getType(), (int)record.getDclass(), (long)record.getTtl(), (byte[])record.getData());
                retVal.addRR(rec);
            }
        }
        catch (Exception e) {
            throw new DNSException(DNSError.newError(2), "Failure while parsing generic record data: " + e.getMessage(), e);
        }
        return retVal;
    }

    @Override
    protected Collection<Record> processGenericANYRecordRequest(String name) throws DNSException {
        DnsRecord[] records;
        try {
            records = this.proxy.getDNSByNameAndType(name, 255);
        }
        catch (Exception e) {
            throw new DNSException(DNSError.newError(2), "DNS service proxy call for DNS records failed: " + e.getMessage(), e);
        }
        if (records == null || records.length == 0) {
            return null;
        }
        ArrayList<Record> retVal = new ArrayList<Record>();
        try {
            for (DnsRecord record : records) {
                Record rec = Record.newRecord((Name)Name.fromString((String)record.getName()), (int)record.getType(), (int)record.getDclass(), (long)record.getTtl(), (byte[])record.getData());
                retVal.add(rec);
            }
        }
        catch (Exception e) {
            throw new DNSException(DNSError.newError(2), "Failure while parsing generic record data: " + e.getMessage(), e);
        }
        return retVal;
    }

    @Override
    protected RRset processCERTRecordRequest(String name) throws DNSException {
        Certificate[] certs;
        if (name.endsWith(".")) {
            name = name.substring(0, name.length() - 1);
        }
        try {
            certs = this.proxy.getCertificatesForOwner(name, null);
        }
        catch (Exception e) {
            throw new DNSException(DNSError.newError(2), "DNS service proxy call for certificates failed: " + e.getMessage(), e);
        }
        if (certs == null || certs.length == 0) {
            int previousIndex = 0;
            int replaceIndex = 0;
            while ((replaceIndex = name.indexOf(".", previousIndex)) > -1) {
                char[] chars = name.toCharArray();
                chars[replaceIndex] = 64;
                try {
                    certs = this.proxy.getCertificatesForOwner(String.copyValueOf(chars), null);
                }
                catch (Exception e) {
                    throw new DNSException(DNSError.newError(2), "DNS service proxy call for certificates failed: " + e.getMessage(), e);
                }
                if (certs != null && certs.length > 0 || replaceIndex >= name.length() - 1) break;
                previousIndex = replaceIndex + 1;
            }
        }
        if (certs == null || certs.length == 0) {
            return null;
        }
        if (!name.endsWith(".")) {
            name = name + ".";
        }
        RRset retVal = new RRset();
        try {
            for (Certificate cert : certs) {
                int certRecordType = 1;
                byte[] retData = null;
                X509Certificate xCert = null;
                try {
                    CertUtils.CertContainer cont = CertUtils.toCertContainer((byte[])cert.getData());
                    xCert = cont.getCert();
                    if (!this.isCertCompliantWithPolicy(xCert)) continue;
                    retData = xCert.getEncoded();
                }
                catch (CertificateConversionException cont) {
                    // empty catch block
                }
                if (xCert == null) {
                    try {
                        retData = cert.getData();
                        URL url = new URL(new String(retData));
                        certRecordType = 253;
                    }
                    catch (Exception e) {
                        throw new DNSException(DNSError.newError(2), "Failure while parsing CERT record data: " + e.getMessage(), e);
                    }
                }
                int keyTag = 0;
                int alg = 0;
                if (xCert != null && xCert.getPublicKey() instanceof RSAKey) {
                    RSAKey key = (RSAKey)((Object)xCert.getPublicKey());
                    byte[] modulus = key.getModulus().toByteArray();
                    keyTag = modulus[modulus.length - 2] << 8 & 0xFF00;
                    keyTag |= modulus[modulus.length - 1] & 0xFF;
                    alg = xCert.getSigAlgOID().equalsIgnoreCase(SignatureAlgorithmIdentifier.SHA1RSA.getId()) ? 5 : (xCert.getSigAlgOID().equalsIgnoreCase(SignatureAlgorithmIdentifier.SHA256RSA.getId()) ? 8 : (xCert.getSigAlgOID().equalsIgnoreCase(SignatureAlgorithmIdentifier.SHA1DSA.getId()) ? 3 : (xCert.getSigAlgOID().equalsIgnoreCase(SignatureAlgorithmIdentifier.MD5RSA.getId()) ? 1 : 5)));
                }
                CERTRecord rec = new CERTRecord(Name.fromString((String)name), 1, 86400L, certRecordType, keyTag, alg, retData);
                retVal.addRR((Record)rec);
            }
        }
        catch (Exception e) {
            throw new DNSException(DNSError.newError(2), "Failure while parsing CERT record data: " + e.getMessage(), e);
        }
        return retVal.size() == 0 ? null : retVal;
    }

    @Override
    protected synchronized Record checkForSoaRecord(String questionName) {
        Record retVal;
        block8: {
            if (!questionName.endsWith(".")) {
                questionName = questionName + ".";
            }
            if (this.soaRecords == null) {
                DnsRecord[] getRecs = null;
                try {
                    getRecs = this.proxy.getDNSByType(6);
                    if (getRecs == null || getRecs.length == 0) {
                        this.soaRecords = Collections.emptyMap();
                    } else {
                        this.soaRecords = new HashMap();
                        for (DnsRecord rec : getRecs) {
                            Record newRec = Record.newRecord((Name)Name.fromString((String)rec.getName()), (int)6, (int)rec.getDclass(), (long)rec.getTtl(), (byte[])rec.getData());
                            this.soaRecords.put(newRec.getName().toString(), newRec);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Failed to load SOA records from config service.");
                }
            }
            retVal = null;
            if (this.soaRecords.size() <= 0 || (retVal = (Record)this.soaRecords.get(questionName)) != null) break block8;
            int index = -1;
            while ((index = questionName.indexOf(".")) > 0 && index < questionName.length() - 1 && (retVal = (Record)this.soaRecords.get(questionName = questionName.substring(index + 1))) == null) {
            }
        }
        return retVal;
    }
}

