/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.Socket;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.dns.DNSException;
import org.nhindirect.dns.DNSResponder;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSSocketServerMBean;

public abstract class DNSSocketServer
implements DNSSocketServerMBean {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(DNSSocketServer.class);
    protected final DNSServerSettings settings;
    protected final DNSResponder responder;
    protected ExecutorService socketAcceptService;
    protected ThreadPoolExecutor dnsRequestService;
    protected final AtomicBoolean running;
    private long serverStartTime = Long.MAX_VALUE;
    private volatile long rejectedCount = 0L;
    private volatile long requestCount = 0L;
    private TemporalCountBucket[] countBuckets = new TemporalCountBucket[]{new TemporalCountBucket(), new TemporalCountBucket(), new TemporalCountBucket(), new TemporalCountBucket(), new TemporalCountBucket()};

    public DNSSocketServer(DNSServerSettings settings, DNSResponder responsder) throws DNSException {
        this.running = new AtomicBoolean(false);
        this.settings = settings;
        this.responder = responsder;
        this.createServerSocket();
    }

    protected void registerMBean(Class<?> clazz) {
        StringBuilder objectNameBuilder = new StringBuilder(clazz.getPackage().getName());
        objectNameBuilder.append(":type=").append(clazz.getSimpleName());
        objectNameBuilder.append(",name=").append(UUID.randomUUID());
        try {
            StandardMBean mbean = new StandardMBean(this, DNSSocketServerMBean.class);
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            mbeanServer.registerMBean(mbean, new ObjectName(objectNameBuilder.toString()));
        }
        catch (JMException e) {
            LOGGER.error((Object)"Unable to register the DNSSocketServer MBean", (Throwable)e);
        }
    }

    public void start() throws DNSException {
        if (!this.running.get()) {
            this.running.set(true);
            this.dnsRequestService = new ThreadPoolExecutor(0, this.settings.getMaxActiveRequests(), 120L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            this.socketAcceptService = Executors.newSingleThreadExecutor();
            this.socketAcceptService.execute(this.getSocketAcceptTask());
            this.serverStartTime = System.currentTimeMillis();
        } else {
            LOGGER.info((Object)"Start requested, but socket server is already running.");
        }
    }

    public void stop() throws DNSException {
        this.running.set(false);
        this.socketAcceptService.shutdown();
        this.dnsRequestService.shutdown();
    }

    protected void waitForGracefulStop() {
        try {
            this.socketAcceptService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.dnsRequestService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public abstract void createServerSocket() throws DNSException;

    public abstract Runnable getSocketAcceptTask();

    public abstract Runnable getDNSRequestTask(Object var1);

    protected void submitDNSRequest(Object s) {
        this.updateCountMetrics();
        boolean executed = false;
        if (this.dnsRequestService.getActiveCount() < this.settings.getMaxActiveRequests()) {
            try {
                this.dnsRequestService.execute(this.getDNSRequestTask(s));
                executed = true;
            }
            catch (RejectedExecutionException e) {
                LOGGER.warn((Object)("Rejecting DNS request: " + e.getMessage()));
            }
        }
        if (!executed) {
            ++this.rejectedCount;
            try {
                if (s instanceof Socket) {
                    ((Socket)s).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCountMetrics() {
        ++this.requestCount;
        long curTime = System.currentTimeMillis();
        int bucketIndex = (int)(curTime / 1000L % 5L);
        TemporalCountBucket[] temporalCountBucketArray = this.countBuckets;
        synchronized (this.countBuckets) {
            TemporalCountBucket bucket = this.countBuckets[bucketIndex];
            bucket.increment(curTime);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Long getUptime() {
        if (!this.running.get() || this.serverStartTime == Long.MAX_VALUE) {
            return -1L;
        }
        return System.currentTimeMillis() - this.serverStartTime;
    }

    @Override
    public Long getRejectedRequestCount() {
        return this.rejectedCount;
    }

    @Override
    public Long getResourceRequestCount() {
        return this.requestCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getResourceRequestLoad() {
        long curTime = System.currentTimeMillis();
        int numTransactions = 0;
        TemporalCountBucket[] temporalCountBucketArray = this.countBuckets;
        synchronized (this.countBuckets) {
            for (TemporalCountBucket bucket : this.countBuckets) {
                numTransactions = (int)((long)numTransactions + bucket.getCount(curTime));
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            double div = 4.0 + (double)(curTime % 1000L / 1000L);
            int aveTransLoad = (int)((double)numTransactions / div);
            return aveTransLoad + "/sec";
        }
    }

    private static class TemporalCountBucket {
        private volatile long count = 0L;
        private volatile long firstAddedTime = 0L;

        private TemporalCountBucket() {
        }

        public synchronized void increment(long accessTime) {
            if (accessTime - this.firstAddedTime > 5000L) {
                this.firstAddedTime = accessTime - accessTime % 1000L;
                this.count = 1L;
            } else {
                ++this.count;
            }
        }

        public synchronized long getCount(long accessTime) {
            if (this.firstAddedTime == 0L) {
                return 0L;
            }
            return accessTime - this.firstAddedTime > 5000L ? 0L : this.count;
        }
    }
}

