/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.config;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.nhind.config.rest.SettingService;
import org.nhind.config.rest.impl.DefaultSettingService;
import org.nhindirect.common.rest.ServiceSecurityManager;
import org.nhindirect.config.model.Setting;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSStore;
import org.nhindirect.dns.config.DNSServerConfig;
import org.nhindirect.dns.config.WSDNSServerConfig;
import org.nhindirect.dns.module.DNSServerModule;
import org.nhindirect.dns.provider.BasicDNSServerSettingsProvider;
import org.nhindirect.dns.provider.ConfigServiceRESTDNSStoreProvider;

public class RESTDNSServerConfig
implements DNSServerConfig {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(WSDNSServerConfig.class);
    private static final String DNS_SERVER_BINDING = "DNSServerBindings";
    private static final String DNS_SERVER_PORT = "DNSServerPort";
    private Provider<DNSStore> storeProvider;
    private Provider<DNSServerSettings> settings;
    private HttpClient httpClient;
    private ServiceSecurityManager secMgr;
    private final String configServiceLocation;
    private final SettingService settingService;

    public RESTDNSServerConfig(String configServiceLocation, HttpClient httpClient, ServiceSecurityManager secMgr, Provider<DNSStore> storeProvider, Provider<DNSServerSettings> settings) {
        this.storeProvider = storeProvider;
        this.configServiceLocation = configServiceLocation;
        this.settings = settings;
        this.httpClient = httpClient;
        this.secMgr = secMgr;
        this.settingService = new DefaultSettingService(configServiceLocation, httpClient, secMgr);
    }

    @Override
    public Injector getServerInjector() {
        LOGGER.info((Object)("Looking up DNS server configuration info from location " + this.configServiceLocation));
        Provider<DNSServerSettings> settingsProv = this.getServerSettings();
        try {
            if (this.storeProvider == null) {
                this.storeProvider = new ConfigServiceRESTDNSStoreProvider(new URL(this.configServiceLocation), this.httpClient, this.secMgr);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Conguration location is not a valid URL", e);
        }
        DNSServerModule module = DNSServerModule.create(this.storeProvider, settingsProv);
        return Guice.createInjector((Module[])new Module[]{module});
    }

    private Provider<DNSServerSettings> getServerSettings() {
        String ipBindings = "";
        int port = 0;
        try {
            Setting setting = this.settingService.getSetting(DNS_SERVER_BINDING);
            if (setting != null) {
                ipBindings = setting.getValue();
            }
            if ((setting = this.settingService.getSetting(DNS_SERVER_PORT)) != null) {
                String sPort = setting.getValue();
                try {
                    port = Integer.parseInt(sPort);
                }
                catch (Exception e) {
                    LOGGER.warn((Object)("Could not parse port setting " + port + " from configuration service"));
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Could not get DNS setting from web service.");
        }
        if ((ipBindings == null || ipBindings.length() == 0) && port == 0 && this.settings != null) {
            LOGGER.info((Object)"Using DNS server settings from injected provider.");
            return this.settings;
        }
        LOGGER.info((Object)"Using DNS server settings from configuration service.");
        return new BasicDNSServerSettingsProvider(ipBindings, port);
    }
}

