/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.service;

import com.google.inject.Provider;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.dns.DNSException;
import org.nhindirect.dns.DNSServer;
import org.nhindirect.dns.DNSServerFactory;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSStore;
import org.nhindirect.dns.provider.AbstractConfigDNSStoreProvider;
import org.nhindirect.dns.provider.BasicDNSServerSettingsProvider;

public class DNSServerService {
    protected static final String DNS_STORE_PROVIDER_VAR = "org.nhindirect.dns.DNSStoreProviderClass";
    private static final Log LOGGER = LogFactory.getFactory().getInstance(DNSServerService.class);
    protected final DNSServer server;

    public DNSServerService(URL configLocation, DNSServerSettings settings) throws DNSException {
        LOGGER.info((Object)("Creating the DNSServer using configuration location " + configLocation.toExternalForm()));
        BasicDNSServerSettingsProvider settingsProv = new BasicDNSServerSettingsProvider(settings.getBindAddress(), settings.getPort());
        Provider<DNSStore> dnsStoreProvider = this.getDNSStoreProvider(configLocation);
        this.server = DNSServerFactory.createDNSServer(configLocation, dnsStoreProvider, settingsProv);
        LOGGER.info((Object)"DNS Server created.  Starting server.");
        this.server.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    LOGGER.info((Object)"Shutdown hook detected.  Intiate server shutdown.");
                    DNSServerService.this.stopService();
                }
                catch (DNSException dNSException) {
                    // empty catch block
                }
            }
        });
    }

    protected Provider<DNSStore> getDNSStoreProvider(URL configLocation) {
        Provider retVal = null;
        String className = System.getProperty(DNS_STORE_PROVIDER_VAR);
        if (className != null && !className.isEmpty()) {
            try {
                Class<?> loadedClazz = DNSServerService.class.getClassLoader().loadClass(className);
                retVal = AbstractConfigDNSStoreProvider.class.isAssignableFrom(loadedClazz) ? (Provider)loadedClazz.getConstructor(URL.class).newInstance(configLocation) : (Provider)loadedClazz.newInstance();
                LOGGER.info((Object)("Loaded Provider<DNSStore> class " + className + " for creating the DNSStore"));
            }
            catch (Throwable e) {
                LOGGER.error((Object)("Could not load or construct instance of Provider<DNSStore> class " + className + "  A default provider will be used."), e);
            }
        } else {
            LOGGER.info((Object)"A DNSStore provider class was not set.  A default provider will be used.");
        }
        return retVal;
    }

    public synchronized void stopService() throws DNSException {
        if (this.server != null) {
            LOGGER.info((Object)"Shutting down DNS server.");
            this.server.stop();
        }
    }
}

