/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.service;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.nhindirect.dns.DNSException;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.service.DNSServerService;

public class SimpleServiceRunner {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(SimpleServiceRunner.class);
    private static final String MODE_STANDALONE = "STANDALONE";
    private static final String MODE_SERVER = "SERVER";
    private static int port;
    private static String bind;
    private static URL servURL;
    private static String mode;

    public static void main(String[] argv) {
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (!arg.startsWith("-")) {
                System.err.println("Error: Unexpected argument [" + arg + "]\n");
                SimpleServiceRunner.printUsage();
                System.exit(-1);
                continue;
            }
            if (arg.equalsIgnoreCase("-p")) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing port.");
                    System.exit(-1);
                }
                port = Integer.parseInt(argv[++i]);
                continue;
            }
            if (arg.equals("-b")) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing bind IP address.");
                    System.exit(-1);
                }
                bind = argv[++i];
                String checkIP = "";
                try {
                    String[] ips;
                    String[] stringArray = ips = bind.split(",");
                    int n = stringArray.length;
                    for (int j = 0; j < n; ++j) {
                        String ip;
                        checkIP = ip = stringArray[j];
                        Inet4Address.getByName(checkIP);
                    }
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Error in bind IP address " + checkIP + " : " + e.getMessage());
                    System.exit(-1);
                    continue;
                }
            }
            if (arg.equals("-u")) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing service URL");
                    System.exit(-1);
                }
                String url = argv[++i];
                try {
                    servURL = new URL(url);
                }
                catch (Exception e) {
                    System.err.println("Error in service URL parameter: " + e.getMessage());
                    System.exit(-1);
                }
                continue;
            }
            if (arg.equals("-m")) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing mode");
                    System.exit(-1);
                }
                if ((mode = argv[++i]).equalsIgnoreCase(MODE_STANDALONE) || mode.equalsIgnoreCase(MODE_SERVER)) continue;
                System.err.println("Unknown mode: " + mode);
                System.exit(-1);
                continue;
            }
            if (arg.equals("-help")) {
                SimpleServiceRunner.printUsage();
                System.exit(-1);
                continue;
            }
            System.err.println("Error: Unknown argument " + arg + "\n");
            SimpleServiceRunner.printUsage();
            System.exit(-1);
        }
        SimpleServiceRunner.startAndRun();
        if (mode.equalsIgnoreCase(MODE_STANDALONE)) {
            System.exit(0);
        }
    }

    private static void startAndRun() {
        StringBuffer buffer = new StringBuffer("Starting DNS server.  Settings:");
        buffer.append("\r\n\tBind Addresses: ").append(bind);
        buffer.append("\r\n\tListen Port: ").append(port);
        buffer.append("\r\n\tService URL: ").append(servURL.toString());
        LOGGER.info((Object)(buffer.toString() + "\n"));
        DNSServerService server = null;
        try {
            DNSServerSettings settings = new DNSServerSettings();
            settings.setPort(port);
            settings.setBindAddress(bind);
            server = new DNSServerService(servURL, settings);
        }
        catch (DNSException e) {
            LOGGER.error((Object)("Server failed to start: " + e.getMessage()), (Throwable)e);
            return;
        }
        if (mode.equalsIgnoreCase(MODE_STANDALONE)) {
            LOGGER.info((Object)"\r\nServer running....  Press Enter or Return to stop.");
            InputStreamReader input = new InputStreamReader(System.in);
            BufferedReader reader = new BufferedReader(input);
            try {
                reader.readLine();
                LOGGER.info((Object)"Shutting down server.  Wait 5 seconds for cleanup.");
                server.stopService();
                Thread.sleep(5000L);
                LOGGER.info((Object)"Server stopped");
            }
            catch (Exception exception) {}
        } else {
            LOGGER.info((Object)"\r\nServer running.");
        }
    }

    private static void printUsage() {
        StringBuffer use = new StringBuffer();
        use.append("Usage:\n");
        use.append("java SimpleDNSServiceRunner (options)...\n\n");
        use.append("options:\n");
        use.append("-p    port    IP listener port.\n");
        use.append("\t\t\t      Default: 53\n\n");
        use.append("-b    bind    Comma limited list of IP addresses to bind to.\n");
        use.append("\t\t\t      Default: 0.0.0.0 (All IP addresses on local machine)\n\n");
        use.append("-u    URL\t  URL of DNS configuration service.\n");
        use.append("\t\t\t      Default: http://localhost:8080/config-service/ConfigurationService\n\n");
        use.append("-m    mode\t  Run mode: STANDALONE or SERVER.\n");
        use.append("\t\t\t      Default: STANDALONE\n\n");
        System.err.println(use);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        port = 53;
        bind = "0.0.0.0";
        mode = MODE_STANDALONE;
        try {
            servURL = new URL("http://localhost:8080/config-service/ConfigurationService");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

