/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.dns.DNSException;
import org.nhindirect.dns.DNSResponder;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSSocketServer;
import org.xbill.DNS.Message;

public class TCPServer
extends DNSSocketServer {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(TCPServer.class);
    private ServerSocket serverSocket;
    private volatile long missCount = 0L;
    private volatile long errorCount = 0L;
    private volatile long successCount = 0L;

    public TCPServer(DNSServerSettings settings, DNSResponder responder) throws DNSException {
        super(settings, responder);
        this.registerMBean(this.getClass());
    }

    @Override
    public void start() throws DNSException {
        LOGGER.info((Object)"DNS TCP Server Starting");
        super.start();
        if (LOGGER.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("DNS TCP Server Startup Complete\r\n\tBind Address: ").append(this.settings.getBindAddress());
            builder.append("\r\n\tBind Port: ").append(this.settings.getPort());
            LOGGER.info((Object)builder.toString());
        }
    }

    @Override
    public void stop() throws DNSException {
        super.stop();
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.waitForGracefulStop();
    }

    @Override
    public void createServerSocket() throws DNSException {
        try {
            this.serverSocket = new ServerSocket(this.settings.getPort(), this.settings.getMaxConnectionBacklog(), Inet4Address.getByName(this.settings.getBindAddress()));
        }
        catch (Exception e) {
            throw new DNSException(null, "Failed to create TCP server socket: " + e.getMessage(), e);
        }
    }

    @Override
    public Runnable getSocketAcceptTask() {
        return new AcceptTask();
    }

    @Override
    public Runnable getDNSRequestTask(Object s) {
        return new RequestTask((Socket)s);
    }

    private void reconnect() {
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.serverSocket = null;
        while (this.serverSocket == null && this.running.get()) {
            try {
                this.createServerSocket();
                LOGGER.error((Object)"DNS TCP server socket re-established");
            }
            catch (DNSException ex) {
                LOGGER.error((Object)"DNS TCP server socket failed to rebind.  Trying again in 5 seconds.");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public Long getMissedRequestCount() {
        return this.missCount;
    }

    @Override
    public Long getSuccessfulRequestCount() {
        return this.successCount;
    }

    @Override
    public Long getErrorRequestCount() {
        return this.errorCount;
    }

    private class RequestTask
    implements Runnable {
        private Socket requestSocket;

        public RequestTask(Socket s) {
            this.requestSocket = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Message response = null;
            Message query = null;
            try {
                block25: {
                    int inLength;
                    DataInputStream dataIn;
                    InputStream is = null;
                    try {
                        is = this.requestSocket.getInputStream();
                        dataIn = new DataInputStream(is);
                        inLength = dataIn.readUnsignedShort();
                    }
                    catch (Exception e) {
                        try {
                            this.requestSocket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            this.requestSocket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return;
                    }
                    byte[] in = new byte[inLength];
                    dataIn.readFully(in);
                    try {
                        query = TCPServer.this.responder.toMessage(in);
                        response = TCPServer.this.responder.processRequest(query);
                    }
                    catch (DNSException e) {
                        if (query == null) break block25;
                        response = TCPServer.this.responder.processError(query, e.getError());
                    }
                }
                if (response != null) {
                    if (response.getRcode() == 0 || response.getRcode() == 3) {
                        ++TCPServer.this.successCount;
                        if (response.getSectionArray(1).length == 0) {
                            ++TCPServer.this.missCount;
                        }
                    } else {
                        ++TCPServer.this.errorCount;
                    }
                    DataOutputStream dataOut = new DataOutputStream(this.requestSocket.getOutputStream());
                    byte[] writeBytes = response.toWire();
                    dataOut.writeShort(writeBytes.length);
                    dataOut.write(writeBytes);
                } else {
                    ++TCPServer.this.errorCount;
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)("Wire/connection protocol error handing DNS request: " + e.getMessage()), (Throwable)e);
            }
            finally {
                try {
                    this.requestSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private class AcceptTask
    implements Runnable {
        private AcceptTask() {
        }

        @Override
        public void run() {
            while (TCPServer.this.running.get()) {
                try {
                    Socket s = TCPServer.this.serverSocket.accept();
                    s.setReceiveBufferSize(TCPServer.this.settings.getMaxRequestSize());
                    s.setSoTimeout(TCPServer.this.settings.getReceiveTimeout());
                    TCPServer.this.submitDNSRequest(s);
                }
                catch (Throwable e) {
                    if (!TCPServer.this.running.get()) continue;
                    LOGGER.error((Object)("DNS TCP server socket dropped:" + e.getMessage()));
                    TCPServer.this.reconnect();
                }
            }
        }
    }
}

