/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.crypto.impl;

import java.security.Key;
import java.security.KeyStore;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.common.crypto.exceptions.CryptoException;

public class BootstrappedKeyStoreProtectionManager
implements KeyStoreProtectionManager {
    public static final String PrivKeyProtKey = "PrivKeyProtKey";
    public static final String KeyStoreProtKey = "KeyStoreProtKey";
    protected Key keyStoreProtectionKey;
    protected Key privateKeyProtectionKey;
    protected Map<String, KeyStore.Entry> keyEntries;

    public BootstrappedKeyStoreProtectionManager() {
        this.setKeyEntries(null);
    }

    public BootstrappedKeyStoreProtectionManager(String keyStoreProtectionKey, String privateKeyProtectionKey) {
        this.setKeyStoreProtectionKey(keyStoreProtectionKey);
        this.setPrivateKeyProtectionKey(privateKeyProtectionKey);
        this.setKeyEntries(null);
    }

    public BootstrappedKeyStoreProtectionManager(String keyStoreProtectionKey, String privateKeyProtectionKey, Map<String, KeyStore.Entry> entries) {
        this.setKeyStoreProtectionKey(keyStoreProtectionKey);
        this.setPrivateKeyProtectionKey(privateKeyProtectionKey);
        this.setKeyEntries(entries);
    }

    public void setKeyStoreProtectionKey(byte[] keyStoreProtectionKey) {
        this.keyStoreProtectionKey = new SecretKeySpec(keyStoreProtectionKey, "");
        this.keyEntries.put(KeyStoreProtKey, new KeyStore.SecretKeyEntry((SecretKey)this.keyStoreProtectionKey));
    }

    public void setKeyStoreProtectionKey(String keyStoreProtectionKey) {
        this.keyStoreProtectionKey = new SecretKeySpec(keyStoreProtectionKey.getBytes(), "");
        this.keyEntries.put(KeyStoreProtKey, new KeyStore.SecretKeyEntry((SecretKey)this.keyStoreProtectionKey));
    }

    public void setPrivateKeyProtectionKey(byte[] privateKeyProtectionKey) {
        this.privateKeyProtectionKey = new SecretKeySpec(privateKeyProtectionKey, "");
        this.keyEntries.put(PrivKeyProtKey, new KeyStore.SecretKeyEntry((SecretKey)this.privateKeyProtectionKey));
    }

    public void setPrivateKeyProtectionKey(String privateKeyProtectionKey) {
        this.privateKeyProtectionKey = new SecretKeySpec(privateKeyProtectionKey.getBytes(), "");
        this.keyEntries.put(PrivKeyProtKey, new KeyStore.SecretKeyEntry((SecretKey)this.privateKeyProtectionKey));
    }

    public void setKeyEntries(Map<String, KeyStore.Entry> entries) {
        Map<String, KeyStore.Entry> map = this.keyEntries = entries == null ? new HashMap<String, KeyStore.Entry>() : new HashMap<String, KeyStore.Entry>(entries);
        if (this.keyStoreProtectionKey != null) {
            this.keyEntries.put(PrivKeyProtKey, new KeyStore.SecretKeyEntry((SecretKey)this.keyStoreProtectionKey));
        }
        if (this.keyStoreProtectionKey != null) {
            this.keyEntries.put(KeyStoreProtKey, new KeyStore.SecretKeyEntry((SecretKey)this.privateKeyProtectionKey));
        }
    }

    @Override
    public Key getPrivateKeyProtectionKey() throws CryptoException {
        return this.privateKeyProtectionKey;
    }

    @Override
    public Key getKeyStoreProtectionKey() throws CryptoException {
        return this.keyStoreProtectionKey;
    }

    @Override
    public Map<String, Key> getAllKeys() throws CryptoException {
        HashMap<String, Key> keys = new HashMap<String, Key>();
        for (Map.Entry<String, KeyStore.Entry> keyEntry : this.keyEntries.entrySet()) {
            if (!(keyEntry.getValue() instanceof KeyStore.SecretKeyEntry)) continue;
            keys.put(keyEntry.getKey(), ((KeyStore.SecretKeyEntry)keyEntry.getValue()).getSecretKey());
        }
        return keys;
    }

    @Override
    public Key getKey(String keyName) throws CryptoException {
        KeyStore.Entry keyEntry = this.getEntry(keyName);
        if (keyEntry != null && keyEntry instanceof KeyStore.SecretKeyEntry) {
            return ((KeyStore.SecretKeyEntry)keyEntry).getSecretKey();
        }
        return null;
    }

    @Override
    public Map<String, KeyStore.Entry> getAllEntries() throws CryptoException {
        return Collections.unmodifiableMap(this.keyEntries);
    }

    @Override
    public KeyStore.Entry getEntry(String entryName) throws CryptoException {
        return this.keyEntries.get(entryName);
    }
}

