/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.crypto.tools.commands;

import java.io.File;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;
import org.nhindirect.common.crypto.MutableKeyStoreProtectionManager;
import org.nhindirect.common.crypto.WrappableKeyProtectionManager;
import org.nhindirect.common.crypto.tools.commands.KeyModel;
import org.nhindirect.common.crypto.tools.commands.printers.KeyPrinter;
import org.nhindirect.common.tooling.Command;
import org.nhindirect.common.tooling.StringArrayUtil;

public class PKCS11Commands {
    private static final String LIST_SECRET_KEYS = "Lists secret keys in the HSM";
    private static final String ADD_RANDOM_SECRET_KEY = "Creates a new named random AES128 secret key\r\n\r\n  keyName\r\n\t keyName: The unique name of the new secret key.  Place the key name in quotes (\"\") if there are spaces in the name.";
    private static final String ADD_USER_SECRET_KEY = "Creates a new named AES128 secret key via user entered text\r\n\r\n  keyName keyText\r\n\t keyName: The unique name of the new secret key.  Place the key name in quotes (\"\") if there are spaces in the name.\r\n\t keyText: The user entered key text.  Place the text in quotes (\"\") if there are spaces in the text.";
    private static final String REMOVE_SECRET_KEY = "Removes a new named secret key\r\n \r\n  keyName\r\n\t keyName: The unique name of the secret key.  Place the key name in quotes (\"\") if there are spaces in the name.";
    private static final String IMPORT_P12_FILE_FOR_TEMP_KEY = "Imports a p12 file and creates a temporary private key entry.\r\n \r\n  p12FileName keyStorePass privKeyPass \r\n\t  p12FileName Full path of the p12 file \r\n\t  keyStorePass Optional keystore password.  Using empty quotes if empty \r\n\t  privKeyPass Optional private key password.  Using empty quotes if empty ";
    protected final KeyPrinter keyPrinter;
    protected final MutableKeyStoreProtectionManager mgr;

    public PKCS11Commands(MutableKeyStoreProtectionManager mgr) {
        this.mgr = mgr;
        this.keyPrinter = new KeyPrinter();
    }

    @Command(name="ListSecretKeys", usage="Lists secret keys in the HSM")
    public void listCerts(String[] args) {
        try {
            Map<String, Key> keys = this.mgr.getAllKeys();
            if (keys.isEmpty()) {
                System.out.println("No keys found");
            } else {
                ArrayList<KeyModel> models = new ArrayList<KeyModel>();
                for (Map.Entry<String, Key> entry : keys.entrySet()) {
                    char[] keyText = entry.getValue().getEncoded() != null ? "*****".toCharArray() : "Not Extractable".toCharArray();
                    KeyModel keyModel = new KeyModel(entry.getKey(), entry.getValue(), keyText);
                    models.add(keyModel);
                }
                this.keyPrinter.printRecords(models);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Command(name="CreateRandomSecretKey", usage="Creates a new named random AES128 secret key\r\n\r\n  keyName\r\n\t keyName: The unique name of the new secret key.  Place the key name in quotes (\"\") if there are spaces in the name.")
    public void addRandomSecretKey(String[] args) {
        String keyName = StringArrayUtil.getRequiredValue(args, 0);
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES", this.mgr.getKS().getProvider().getName());
            keyGen.init(128);
            SecretKey key = keyGen.generateKey();
            this.mgr.clearKey(keyName);
            this.mgr.setKey(keyName, key);
        }
        catch (Exception e) {
            System.err.println("Failed to add new random secret key: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Command(name="CreateUserSecretKey", usage="Creates a new named AES128 secret key via user entered text\r\n\r\n  keyName keyText\r\n\t keyName: The unique name of the new secret key.  Place the key name in quotes (\"\") if there are spaces in the name.\r\n\t keyText: The user entered key text.  Place the text in quotes (\"\") if there are spaces in the text.")
    public void addUserSecretKey(String[] args) {
        String keyName = StringArrayUtil.getRequiredValue(args, 0);
        String keyText = StringArrayUtil.getRequiredValue(args, 1);
        try {
            byte[] key = keyText.getBytes("UTF-8");
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
            this.mgr.clearKey(keyName);
            this.mgr.setKey(keyName, new SecretKeySpec(key, "AES"));
        }
        catch (Exception e) {
            System.err.println("Failed to add new random secret key: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Command(name="RemoveSecretKey", usage="Removes a new named secret key\r\n \r\n  keyName\r\n\t keyName: The unique name of the secret key.  Place the key name in quotes (\"\") if there are spaces in the name.")
    public void removeSecretKey(String[] args) {
        String keyName = StringArrayUtil.getRequiredValue(args, 0);
        try {
            this.mgr.clearKey(keyName);
        }
        catch (Exception e) {
            System.err.println("Failed to add new random secret key: " + e.getMessage());
        }
    }

    @Command(name="ImportP12FileForTempKey", usage="Imports a p12 file and creates a temporary private key entry.\r\n \r\n  p12FileName keyStorePass privKeyPass \r\n\t  p12FileName Full path of the p12 file \r\n\t  keyStorePass Optional keystore password.  Using empty quotes if empty \r\n\t  privKeyPass Optional private key password.  Using empty quotes if empty ")
    public void importPrivateKeyFile(String[] args) {
        if (!(this.mgr instanceof WrappableKeyProtectionManager)) {
            System.out.println("Key store manager does not support wrapping.");
            return;
        }
        WrappableKeyProtectionManager wrapMgr = (WrappableKeyProtectionManager)((Object)this.mgr);
        String fileName = StringArrayUtil.getRequiredValue(args, 0);
        String keyStorePass = StringArrayUtil.getOptionalValue(args, 1, "");
        String privKeyPass = StringArrayUtil.getOptionalValue(args, 2, "");
        try {
            byte[] wrappedKey;
            KeyStore pkcs11Store = this.mgr.getKS();
            String providerName = pkcs11Store.getProvider().getName();
            System.out.println("Provider Name: " + providerName);
            KeyGenerator keyGen = KeyGenerator.getInstance("AES", providerName);
            keyGen.init(128);
            SecretKey keyStoreSecretKey = keyGen.generateKey();
            KeyStore store = KeyStore.getInstance("pkcs12");
            store.load(FileUtils.openInputStream((File)new File(fileName)), keyStorePass.toCharArray());
            String alias = store.aliases().nextElement();
            PrivateKey entry = (PrivateKey)store.getKey(alias, privKeyPass.toCharArray());
            byte[] encryptedKey = wrappedKey = wrapMgr.wrapWithSecretKey(keyStoreSecretKey, entry);
            PrivateKey securedPrivateKey = (PrivateKey)wrapMgr.unwrapWithSecretKey(keyStoreSecretKey, encryptedKey, "RSA", 2);
            System.out.println("Successfully created an unwrapped private key");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

