/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.mail.dsn.impl;

import java.util.Enumeration;
import java.util.List;
import javax.mail.Address;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.lang.StringEscapeUtils;
import org.nhindirect.common.mail.dsn.DSNFailureTextBodyPartGenerator;
import org.nhindirect.common.mail.dsn.impl.HumanReadableTextAssembler;
import org.nhindirect.common.mail.dsn.impl.HumanReadableTextAssemblerFactory;

public class DefaultDSNFailureTextBodyPartGenerator
implements DSNFailureTextBodyPartGenerator {
    public static final String ORIGINAL_SENDER_TAG = "%original_sender_tag%";
    public static final String HEADERS_TAG = "%headers_tag%";
    private String header;
    private String footer;
    private String rejectedRecipientsTitle;
    private String errorMessageTitle;
    private String defaultErrorMessage;
    private HumanReadableTextAssemblerFactory humanReadableTextAssemblerFactory;

    public DefaultDSNFailureTextBodyPartGenerator(String header, String footer, String rejectedRecipientsTitle, String errorMessageTitle, String defaultErrorMessage, HumanReadableTextAssemblerFactory humanReadableTextAssemblerFactory) {
        this.header = header;
        this.footer = footer;
        this.rejectedRecipientsTitle = rejectedRecipientsTitle;
        this.errorMessageTitle = errorMessageTitle;
        this.defaultErrorMessage = defaultErrorMessage;
        this.humanReadableTextAssemblerFactory = humanReadableTextAssemblerFactory;
    }

    @Override
    public MimeBodyPart generate(Address originalSender, List<Address> failedRecipients, Enumeration<Header> originalMessageHeaders) throws MessagingException {
        MimeBodyPart part = null;
        if (originalSender == null) {
            throw new MessagingException("originalSender can't be null");
        }
        if (failedRecipients == null) {
            throw new MessagingException("Faile recipients can't be null");
        }
        String populatedHeader = this.header.replace(ORIGINAL_SENDER_TAG, StringEscapeUtils.escapeHtml((String)originalSender.toString()));
        String populatedFooter = null;
        populatedFooter = originalMessageHeaders != null && originalMessageHeaders.hasMoreElements() ? this.footer.replace(HEADERS_TAG, this.headersToString(originalMessageHeaders)) : this.footer;
        HumanReadableTextAssembler assembler = this.humanReadableTextAssemblerFactory.createHumanReadableTextAssembler(populatedHeader, populatedFooter, this.rejectedRecipientsTitle, this.errorMessageTitle, this.defaultErrorMessage);
        part = assembler.assemble(failedRecipients);
        return part;
    }

    protected String headersToString(Enumeration<Header> originalMessageHeaders) {
        StringBuffer sb = new StringBuffer();
        while (originalMessageHeaders.hasMoreElements()) {
            Header h = originalMessageHeaders.nextElement();
            sb.append(StringEscapeUtils.escapeHtml((String)(h.getName() + ": " + h.getValue())));
            sb.append("<br/>");
        }
        return sb.toString();
    }
}

