/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.rest;

import java.io.IOException;
import org.apache.http.client.HttpClient;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.nhindirect.common.rest.ServiceRequest;
import org.nhindirect.common.rest.exceptions.ServiceException;

public abstract class AbstractUnsecuredService {
    protected final String serviceURL;
    protected final HttpClient httpClient;
    protected final ObjectMapper jsonMapper;

    public AbstractUnsecuredService(String serviceURL, HttpClient httpClient) {
        if (httpClient == null || serviceURL == null || serviceURL.isEmpty()) {
            throw new IllegalArgumentException("Invalid parameter received. Got: serviceURL: " + serviceURL + ", httpClient: " + httpClient);
        }
        this.httpClient = httpClient;
        this.serviceURL = serviceURL.endsWith("/") ? serviceURL : serviceURL + "/";
        this.jsonMapper = new ObjectMapper();
        this.jsonMapper.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.jsonMapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    protected static String showSensitive(Object o) {
        int charsToShow = 4;
        if (o == null) {
            return "null";
        }
        String s = o.toString();
        int len = s.length();
        if (len <= 4) {
            return s;
        }
        return s.substring(0, len - 4).replaceAll(".", "*") + s.substring(len - 4);
    }

    protected <T, E extends Exception> T callWithRetry(ServiceRequest<T, E> request) throws E, ServiceException {
        try {
            T t = request.call();
            return t;
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        finally {
            request.destroy();
        }
    }
}

