/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.apache.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.nhindirect.stagent.cert.CertStoreCachePolicy;

public class CertCacheFactory {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(CertCacheFactory.class);
    protected static CertCacheFactory INSTANCE;
    protected final Map<String, JCS> certCacheMap = new HashMap<String, JCS>();

    public static synchronized CertCacheFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CertCacheFactory();
        }
        return INSTANCE;
    }

    private CertCacheFactory() {
    }

    public synchronized JCS getCertCache(String cacheName, CertStoreCachePolicy cachePolicy) throws CacheException {
        JCS retVal = this.certCacheMap.get(cacheName);
        if (retVal == null) {
            try {
                retVal = JCS.getInstance((String)cacheName);
                if (cachePolicy != null) {
                    this.applyCachePolicy(retVal, cachePolicy);
                }
                this.certCacheMap.put(cacheName, retVal);
            }
            catch (CacheException e) {
                LOGGER.warn((Object)("Failed to create JCS cache " + cacheName), (Throwable)e);
                throw e;
            }
        }
        return retVal;
    }

    public synchronized void flushAll() {
        for (Map.Entry<String, JCS> entry : this.certCacheMap.entrySet()) {
            try {
                LOGGER.info((Object)("Flushing cache " + entry.getKey()));
                entry.getValue().clear();
            }
            catch (CacheException cacheException) {}
        }
    }

    private void applyCachePolicy(JCS cache, CertStoreCachePolicy policy) throws CacheException {
        ICompositeCacheAttributes attributes = cache.getCacheAttributes();
        attributes.setMaxObjects(policy.getMaxItems());
        attributes.setUseLateral(false);
        attributes.setUseRemote(false);
        cache.setCacheAttributes(attributes);
        IElementAttributes eattributes = cache.getDefaultElementAttributes();
        eattributes.setMaxLifeSeconds((long)policy.getSubjectTTL());
        eattributes.setIsEternal(false);
        eattributes.setIsLateral(false);
        eattributes.setIsRemote(false);
        cache.setDefaultElementAttributes(eattributes);
    }
}

