/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import com.google.inject.Inject;
import com.google.inject.internal.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.cert.CertificateStore;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cert.impl.annotation.CertStoreKeyFile;
import org.nhindirect.stagent.cert.impl.annotation.CertStoreKeyFilePassword;
import org.nhindirect.stagent.cert.impl.annotation.CertStoreKeyFilePrivKeyPassword;

public class KeyStoreCertificateStore
extends CertificateStore {
    private Set<X509Certificate> certs = new HashSet<X509Certificate>();
    private static final Log LOGGER = LogFactory.getFactory().getInstance(KeyStoreCertificateStore.class);
    protected File keyStoreFile;
    protected String keyStorePassword;
    protected String privateKeyPassword;
    protected KeyStore ks;

    public KeyStoreCertificateStore() {
    }

    public KeyStoreCertificateStore(File keyStoreFile) {
        this(keyStoreFile, null, null);
    }

    public KeyStoreCertificateStore(File keyStoreFile, String keyStorePassword) {
        this(keyStoreFile, keyStorePassword, null);
    }

    @Inject
    public KeyStoreCertificateStore(@CertStoreKeyFile String keyStoreFileName, @Nullable @CertStoreKeyFilePassword String keyStorePassword, @Nullable @CertStoreKeyFilePrivKeyPassword String privateKeyPassword) {
        this.keyStoreFile = new File(keyStoreFileName);
        this.keyStorePassword = keyStorePassword;
        this.privateKeyPassword = privateKeyPassword;
        if (this.keyStoreFile == null) {
            throw new IllegalArgumentException();
        }
        this.bootstrapFromFile();
    }

    public KeyStoreCertificateStore(File keyStoreFile, String keyStorePassword, String privateKeyPassword) {
        this.keyStoreFile = keyStoreFile;
        this.keyStorePassword = keyStorePassword;
        this.privateKeyPassword = privateKeyPassword;
        if (keyStoreFile == null) {
            throw new IllegalArgumentException();
        }
        this.bootstrapFromFile();
    }

    public void setKeyStoreFile(File fl) {
        if (this.ks != null) {
            throw new IllegalStateException();
        }
        this.keyStoreFile = fl;
    }

    public void setKeyStoreFile(String fileName) {
        if (this.ks != null) {
            throw new IllegalStateException();
        }
        this.setKeyStoreFile(new File(fileName));
    }

    public void setKeyStorePassword(String password) {
        if (this.ks != null) {
            throw new IllegalStateException();
        }
        this.keyStorePassword = password;
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        if (this.ks != null) {
            throw new IllegalStateException();
        }
        this.privateKeyPassword = privateKeyPassword;
    }

    public void loadKeyStore() {
        if (this.ks != null) {
            throw new IllegalStateException();
        }
        this.bootstrapFromFile();
    }

    private void bootstrapFromFile() {
        try {
            this.ks = KeyStore.getInstance(KeyStore.getDefaultType());
            if (!this.keyStoreFile.exists()) {
                this.ks.load(null, this.keyStorePassword == null ? null : this.keyStorePassword.toCharArray());
                FileOutputStream outStream = new FileOutputStream(this.keyStoreFile);
                this.ks.store(outStream, this.keyStorePassword == null ? null : this.keyStorePassword.toCharArray());
                IOUtils.closeQuietly((OutputStream)outStream);
            } else {
                FileInputStream inStream = new FileInputStream(this.keyStoreFile);
                this.ks.load(inStream, this.keyStorePassword == null ? null : this.keyStorePassword.toCharArray());
                IOUtils.closeQuietly((InputStream)inStream);
                Enumeration<String> aliases = this.ks.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    Certificate cert = this.ks.getCertificate(alias);
                    if (cert == null || !(cert instanceof X509Certificate)) continue;
                    Key key = this.ks.getKey(alias, this.privateKeyPassword == null ? null : this.privateKeyPassword.toCharArray());
                    X509Certificate addCert = key != null && key instanceof PrivateKey ? X509CertificateEx.fromX509Certificate((X509Certificate)cert, (PrivateKey)key) : (X509Certificate)cert;
                    this.certs.add(addCert);
                }
            }
        }
        catch (Exception e) {
            throw new NHINDException("", e);
        }
    }

    @Override
    public boolean contains(X509Certificate cert) {
        return this.certs.contains(cert);
    }

    @Override
    public void add(X509Certificate cert) {
        String newAlias = cert.getIssuerX500Principal().getName() + ":" + cert.getIssuerX500Principal().getName();
        this.add(cert, newAlias);
    }

    @Override
    public void remove(X509Certificate cert) {
        if (this.certs.remove(cert)) {
            try {
                String alias = this.ks.getCertificateAlias(cert);
                if (alias != null) {
                    this.ks.deleteEntry(alias);
                    FileOutputStream outStream = new FileOutputStream(this.keyStoreFile);
                    this.ks.store(outStream, this.keyStorePassword == null ? null : this.keyStorePassword.toCharArray());
                    IOUtils.closeQuietly((OutputStream)outStream);
                }
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Error attempting to remove certificate: " + e.getMessage()));
            }
        }
    }

    @Override
    public Collection<X509Certificate> getAllCertificates() {
        return new ArrayList<X509Certificate>(this.certs);
    }

    public void add(X509Certificate cert, String alias) {
        if (this.certs.contains(cert)) {
            LOGGER.warn((Object)"Certificate already exists in store.  Use update() instead.");
            return;
        }
        try {
            this.certs.add(cert);
            if (cert instanceof X509CertificateEx) {
                this.ks.setKeyEntry(alias, ((X509CertificateEx)cert).getPrivateKey(), this.privateKeyPassword == null ? null : this.privateKeyPassword.toCharArray(), new Certificate[]{cert});
            } else {
                this.ks.setCertificateEntry(alias, cert);
            }
            FileOutputStream outStream = new FileOutputStream(this.keyStoreFile);
            this.ks.store(outStream, this.keyStorePassword == null ? null : this.keyStorePassword.toCharArray());
            IOUtils.closeQuietly((OutputStream)outStream);
        }
        catch (Throwable e) {
            LOGGER.warn((Object)("Error adding certificate to store: " + e.getMessage()));
        }
    }

    public void update(X509Certificate cert, String alias) {
        if (this.contains(cert)) {
            this.remove(cert);
        }
        this.add(cert, alias);
    }

    public X509Certificate getByAlias(String alias) {
        X509Certificate retVal = null;
        Certificate cert = null;
        try {
            cert = this.ks.getCertificate(alias);
            if (cert != null && cert instanceof X509Certificate) {
                Key key = this.ks.getKey(alias, this.privateKeyPassword == null ? null : this.privateKeyPassword.toCharArray());
                retVal = key != null && key instanceof PrivateKey ? X509CertificateEx.fromX509Certificate((X509Certificate)cert, (PrivateKey)key) : (X509Certificate)cert;
            }
        }
        catch (Exception e) {
            throw new NHINDException("", e);
        }
        return retVal;
    }
}

