/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography.activekeyops;

import java.io.InputStream;
import java.lang.reflect.Field;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.mail.smime.SMIMEEnveloped;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.cryptography.activekeyops.DefaultDirectRecipientInformation;
import org.nhindirect.stagent.cryptography.activekeyops.DirectRecipientInformation;
import org.nhindirect.stagent.cryptography.activekeyops.DirectRecipientInformationFactory;
import org.nhindirect.stagent.cryptography.activekeyops.SplitDirectRecipientInformation;

public class SplitDirectRecipientInformationFactory
implements DirectRecipientInformationFactory {
    protected final String keyEncProvider;
    protected final String encProvider;

    public SplitDirectRecipientInformationFactory() {
        this("", "");
    }

    public SplitDirectRecipientInformationFactory(String keyEncProvider, String encProvider) {
        this.keyEncProvider = StringUtils.isEmpty((String)keyEncProvider) ? CryptoExtensions.getJCESensitiveProviderName() : keyEncProvider;
        this.encProvider = StringUtils.isEmpty((String)encProvider) ? CryptoExtensions.getJCEProviderName() : encProvider;
    }

    @Override
    public DirectRecipientInformation createInstance(RecipientInformation recipient, SMIMEEnveloped env) {
        try {
            if (recipient == null) {
                return null;
            }
            Field infoField = recipient.getClass().getDeclaredField("_info");
            infoField.setAccessible(true);
            Object info = infoField.get(recipient);
            if (!(info instanceof KeyTransRecipientInfo)) {
                return new DefaultDirectRecipientInformation(recipient, "");
            }
            Field encAlgField = CMSEnvelopedData.class.getDeclaredField("encAlg");
            encAlgField.setAccessible(true);
            Object encAlg = encAlgField.get(env);
            Field dataField = RecipientInformation.class.getDeclaredField("_data");
            dataField.setAccessible(true);
            Object data = dataField.get(recipient);
            return new SplitDirectRecipientInformation((KeyTransRecipientInfo)info, (AlgorithmIdentifier)encAlg, (InputStream)data, this.encProvider, this.keyEncProvider);
        }
        catch (Exception e) {
            throw new IllegalStateException("RecipientInformation configuration is not recognized: " + e.getMessage(), e);
        }
    }
}

