/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.nhindirect.policy.LiteralPolicyExpressionFactory;
import org.nhindirect.policy.OperationPolicyExpression;
import org.nhindirect.policy.OperationPolicyExpressionFactory;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.policy.PolicyExpressionType;
import org.nhindirect.policy.PolicyGrammarException;
import org.nhindirect.policy.PolicyOperator;
import org.nhindirect.policy.PolicyOperatorParamsType;
import org.nhindirect.policy.PolicyParseException;
import org.nhindirect.policy.impl.XMLLexiconPolicyParser;
import org.nhindirect.policy.x509.ExtensionField;
import org.nhindirect.policy.x509.ExtensionIdentifier;
import org.nhindirect.policy.x509.IssuerAttributeField;
import org.nhindirect.policy.x509.RDNAttributeIdentifier;
import org.nhindirect.policy.x509.SubjectAttributeField;
import org.nhindirect.policy.x509.TBSField;
import org.nhindirect.policy.x509.TBSFieldName;
import org.nhindirect.policy.x509.X509Field;
import org.nhindirect.policy.x509.X509FieldType;

public class SimpleTextV1LexiconPolicyParser
extends XMLLexiconPolicyParser {
    protected static final Map<String, TokenType> tokenMap;
    protected static Map<String, PolicyOperator> operatorExpressionMap;
    protected ThreadLocal<Integer> buildLevel = new ThreadLocal();

    @Override
    public PolicyExpression parse(InputStream stream) throws PolicyParseException {
        Vector<TokenTypeAssociation> tokens = this.parseToTokens(stream);
        this.resetLevel();
        PolicyExpression retExpression = this.buildExpression(tokens.iterator());
        if (this.getLevel() != 0) {
            throw new PolicyGrammarException("Group not closed.");
        }
        if (retExpression.getExpressionType() != PolicyExpressionType.OPERATION) {
            throw new PolicyGrammarException("Expression must evaluate to an operation");
        }
        return retExpression;
    }

    protected PolicyExpression buildExpression(Iterator<TokenTypeAssociation> tokens) throws PolicyParseException {
        return this.buildExpression(tokens, false);
    }

    protected PolicyExpression buildExpression(Iterator<TokenTypeAssociation> tokens, boolean operandFrame) throws PolicyParseException {
        if (!tokens.hasNext()) {
            return null;
        }
        Vector<PolicyExpression> builtOperandExpressions = new Vector<PolicyExpression>();
        do {
            TokenTypeAssociation assos = tokens.next();
            switch (assos.getType()) {
                case START_LEVEL: {
                    this.incrementLevel();
                    PolicyExpression expression = this.buildExpression(tokens);
                    if (operandFrame) {
                        return expression;
                    }
                    builtOperandExpressions.add(expression);
                    break;
                }
                case END_LEVEL: {
                    if (this.getLevel() == 0) {
                        throw new PolicyGrammarException("To many \")\" tokens.  Delete this token");
                    }
                    if (builtOperandExpressions.size() == 0) {
                        throw new PolicyGrammarException("Group must contain at least one expression.");
                    }
                    this.decrementLevel();
                    return (PolicyExpression)builtOperandExpressions.get(0);
                }
                case OPERATOR_EXPRESSION: {
                    PolicyOperator operator = PolicyOperator.fromToken(assos.getToken());
                    PolicyExpression subExpression = this.buildExpression(tokens, true);
                    if (subExpression == null) {
                        throw new PolicyGrammarException("Missing parameter.  Operator must be followed by an expression.");
                    }
                    builtOperandExpressions.add(subExpression);
                    if (builtOperandExpressions.size() == 1 && operator.getParamsType().equals((Object)PolicyOperatorParamsType.BINARY)) {
                        throw new PolicyGrammarException("Missing parameter.  Binary operators require two parameters.");
                    }
                    OperationPolicyExpression operatorExpression = OperationPolicyExpressionFactory.getInstance(operator, builtOperandExpressions);
                    if (operandFrame) {
                        return operatorExpression;
                    }
                    builtOperandExpressions = new Vector();
                    builtOperandExpressions.add(operatorExpression);
                    break;
                }
                case LITERAL_EXPRESSION: {
                    PolicyExpression expression = LiteralPolicyExpressionFactory.getInstance(assos.getToken());
                    if (operandFrame) {
                        return expression;
                    }
                    builtOperandExpressions.add(expression);
                    break;
                }
                case CERTIFICATE_REFERENCE_EXPRESSION: {
                    PolicyExpression expression = this.buildCertificateReferenceField(assos.getToken());
                    if (operandFrame) {
                        return expression;
                    }
                    builtOperandExpressions.add(expression);
                    break;
                }
            }
        } while (tokens.hasNext());
        if (builtOperandExpressions.size() > 1) {
            throw new PolicyGrammarException("Erroneous expression.");
        }
        return (PolicyExpression)builtOperandExpressions.get(0);
    }

    protected PolicyExpression buildCertificateReferenceField(String token) throws PolicyParseException {
        PolicyExpression checkObj = this.buildX509Field(token);
        if (checkObj == null && (checkObj = this.buildTBSField(token)) == null) {
            checkObj = this.buildExtensionField(token);
        }
        return checkObj;
    }

    protected PolicyExpression buildX509Field(String token) throws PolicyParseException {
        X509Field<?> retVal = null;
        X509FieldType fieldType = X509FieldType.fromToken(token);
        if (fieldType != null) {
            try {
                Class<X509Field<?>> fieldRefClass = fieldType.getReferenceClass();
                if (fieldRefClass == null) {
                    throw new PolicyParseException("X509Field with token name " + token + " has not been implemented yet.");
                }
                retVal = fieldRefClass.newInstance();
            }
            catch (PolicyParseException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new PolicyParseException("Error building X509Field", e);
            }
        }
        return retVal;
    }

    protected PolicyExpression buildTBSField(String token) throws PolicyParseException {
        IssuerAttributeField retVal = null;
        TBSFieldName fieldName = TBSFieldName.fromToken(token);
        if (fieldName != null) {
            try {
                Class<TBSField<?>> fieldRefClass = fieldName.getReferenceClass(token);
                if (fieldRefClass == null) {
                    throw new PolicyParseException("TBSField with token name " + token + " has not been implemented yet.");
                }
                if (fieldRefClass.equals(IssuerAttributeField.class) || fieldRefClass.equals(SubjectAttributeField.class)) {
                    boolean required = token.endsWith("+");
                    String rdnLookupToken = required ? token.substring(0, token.length() - 1) : token;
                    RDNAttributeIdentifier identifier = RDNAttributeIdentifier.fromName(rdnLookupToken);
                    retVal = fieldRefClass.equals(IssuerAttributeField.class) ? new IssuerAttributeField(required, identifier) : new SubjectAttributeField(required, identifier);
                } else {
                    retVal = fieldRefClass.newInstance();
                }
            }
            catch (PolicyParseException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new PolicyParseException("Error building TBSField", e);
            }
        }
        return retVal;
    }

    protected PolicyExpression buildExtensionField(String token) throws PolicyParseException {
        ExtensionField<?> retVal = null;
        ExtensionIdentifier fieldType = ExtensionIdentifier.fromToken(token);
        if (fieldType != null) {
            try {
                boolean required = token.endsWith("+");
                Class<ExtensionField<?>> fieldRefClass = fieldType.getReferenceClass(token);
                if (fieldRefClass == null) {
                    throw new PolicyParseException("ExtensionField with token name " + token + " has not been implemented yet.");
                }
                Constructor<ExtensionField<?>> cons = fieldRefClass.getConstructor(Boolean.TYPE);
                retVal = cons.newInstance(required);
            }
            catch (PolicyParseException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new PolicyParseException("Error building ExtensionField", e);
            }
        }
        return retVal;
    }

    protected Vector<TokenTypeAssociation> parseToTokens(InputStream stream) throws PolicyParseException {
        Vector<TokenTypeAssociation> tokens = new Vector<TokenTypeAssociation>();
        try {
            int i;
            InputStreamReader isr = new InputStreamReader(stream);
            StringWriter writer = new StringWriter();
            boolean holdMode = false;
            TokenType holdType = null;
            block2: while ((i = isr.read()) > 0) {
                writer.write(i);
                String checkForTokenString = writer.toString();
                TokenType exactMatchToken = tokenMap.get(checkForTokenString);
                if (exactMatchToken != null) {
                    if (exactMatchToken == TokenType.OPERATOR_EXPRESSION || exactMatchToken == TokenType.CERTIFICATE_REFERENCE_EXPRESSION) {
                        holdType = exactMatchToken;
                        holdMode = true;
                        continue;
                    }
                    tokens.add(new TokenTypeAssociation(checkForTokenString, exactMatchToken));
                    writer = new StringWriter();
                    continue;
                }
                if (holdMode) {
                    String operatorToken = checkForTokenString.substring(0, checkForTokenString.length() - 1);
                    String nextToken = checkForTokenString.substring(checkForTokenString.length() - 1);
                    tokens.add(new TokenTypeAssociation(operatorToken, holdType));
                    writer = new StringWriter();
                    exactMatchToken = tokenMap.get(nextToken);
                    if (exactMatchToken != null) {
                        tokens.add(new TokenTypeAssociation(nextToken, exactMatchToken));
                    } else {
                        writer.write(nextToken);
                    }
                    holdMode = false;
                    holdType = null;
                    continue;
                }
                for (String key : tokenMap.keySet()) {
                    int idx = checkForTokenString.indexOf(key);
                    if (idx < 0) continue;
                    String firstToken = checkForTokenString.substring(0, idx).trim();
                    String secondToken = checkForTokenString.substring(idx).trim();
                    if (!firstToken.isEmpty()) {
                        tokens.add(new TokenTypeAssociation(firstToken, TokenType.LITERAL_EXPRESSION));
                    }
                    writer = new StringWriter();
                    exactMatchToken = tokenMap.get(secondToken);
                    if (exactMatchToken == TokenType.OPERATOR_EXPRESSION || exactMatchToken == TokenType.CERTIFICATE_REFERENCE_EXPRESSION) {
                        holdMode = true;
                        holdType = exactMatchToken;
                        writer.write(secondToken);
                        continue block2;
                    }
                    tokens.add(new TokenTypeAssociation(secondToken, exactMatchToken));
                    continue block2;
                }
            }
            String remainingString = writer.toString().trim();
            if (!remainingString.isEmpty()) {
                TokenType exactMatchToken = tokenMap.get(remainingString);
                TokenType addTokenType = exactMatchToken != null ? exactMatchToken : TokenType.LITERAL_EXPRESSION;
                tokens.add(new TokenTypeAssociation(remainingString, addTokenType));
            }
        }
        catch (IOException e) {
            throw new PolicyParseException("Error parsing: " + e.getMessage(), e);
        }
        return tokens;
    }

    protected Integer resetLevel() {
        int n;
        Integer level = this.buildLevel.get();
        if (level == null) {
            level = 0;
            n = level;
        } else {
            n = 0;
        }
        level = n;
        this.buildLevel.set(level);
        return level;
    }

    protected Integer getLevel() {
        Integer level = this.buildLevel.get();
        if (level == null) {
            level = this.resetLevel();
        }
        return level;
    }

    protected Integer incrementLevel() {
        Integer level = this.getLevel();
        level = level + 1;
        this.buildLevel.set(level);
        return level;
    }

    protected Integer decrementLevel() {
        Integer level = this.getLevel();
        level = level - 1;
        this.buildLevel.set(level);
        return level;
    }

    static {
        ExtensionIdentifier[] extensionFields;
        TBSFieldName[] tbsFieldNames;
        PolicyOperator[] operators;
        tokenMap = new HashMap<String, TokenType>();
        tokenMap.put("(", TokenType.START_LEVEL);
        tokenMap.put(")", TokenType.END_LEVEL);
        for (PolicyOperator operator : operators = (PolicyOperator[])PolicyOperator[].class.cast(PolicyOperator.class.getEnumConstants())) {
            tokenMap.put(operator.getOperatorToken(), TokenType.OPERATOR_EXPRESSION);
        }
        tokenMap.put(X509FieldType.SIGNATURE.getFieldToken(), TokenType.CERTIFICATE_REFERENCE_EXPRESSION);
        tokenMap.put(X509FieldType.SIGNATURE_ALGORITHM.getFieldToken(), TokenType.CERTIFICATE_REFERENCE_EXPRESSION);
        for (TBSFieldName tbsFieldName : tbsFieldNames = (TBSFieldName[])TBSFieldName[].class.cast(TBSFieldName.class.getEnumConstants())) {
            if (tbsFieldName == TBSFieldName.EXTENSIONS) continue;
            for (String tokenName : tbsFieldName.getFieldTokens()) {
                tokenMap.put(tokenName, TokenType.CERTIFICATE_REFERENCE_EXPRESSION);
            }
        }
        for (ExtensionIdentifier extensionField : extensionFields = (ExtensionIdentifier[])ExtensionIdentifier[].class.cast(ExtensionIdentifier.class.getEnumConstants())) {
            for (String tokenName : extensionField.getFieldTokens()) {
                tokenMap.put(tokenName, TokenType.CERTIFICATE_REFERENCE_EXPRESSION);
            }
        }
    }

    protected static class TokenTypeAssociation {
        protected final String token;
        protected final TokenType type;

        public TokenTypeAssociation(String token, TokenType type) {
            this.token = token;
            this.type = type;
        }

        public String getToken() {
            return this.token;
        }

        public TokenType getType() {
            return this.type;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("");
            builder.append("Token Type: ").append(this.type.toString()).append("\r\nToken Value: ").append(this.token);
            return builder.toString();
        }
    }

    protected static enum TokenType {
        START_LEVEL,
        END_LEVEL,
        OPERATOR_EXPRESSION,
        LITERAL_EXPRESSION,
        CERTIFICATE_REFERENCE_EXPRESSION;

    }
}

