/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl.machine;

import org.nhindirect.policy.Opcode;
import org.nhindirect.policy.PolicyOperator;
import org.nhindirect.policy.PolicyValue;

public class StackMachineEntry
implements Opcode {
    protected final EntryType entryType;
    protected final PolicyOperator operator;
    protected final PolicyValue<?> value;

    public StackMachineEntry(PolicyOperator operator) {
        this.operator = operator;
        this.entryType = EntryType.OPERATOR;
        this.value = null;
    }

    public StackMachineEntry(PolicyValue<?> value) {
        this.operator = null;
        this.entryType = EntryType.VALUE;
        this.value = value;
    }

    public PolicyValue<?> getValue() {
        return this.value;
    }

    public PolicyOperator getOperator() {
        return this.operator;
    }

    public EntryType getEntryType() {
        return this.entryType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Entry Type: ").append((Object)this.getEntryType()).append("\r\n");
        switch (this.getEntryType()) {
            case OPERATOR: {
                builder.append("Operator: " + this.getOperator().getOperatorText() + "\r\n");
                break;
            }
            case VALUE: {
                builder.append("Value: " + this.getValue().getPolicyValue() + "\r\n");
            }
        }
        return builder.toString();
    }

    public static enum EntryType {
        OPERATOR,
        VALUE;

    }
}

