/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.audit.provider;

import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.nhindirect.common.audit.Auditor;
import org.nhindirect.common.audit.impl.MultiProviderAuditor;

public class MultiProviderAuditorProvider
implements Provider<Auditor> {
    private Collection<Auditor> auditors;

    public MultiProviderAuditorProvider(Auditor[] auditors) {
        if (auditors == null || auditors.length == 0) {
            throw new IllegalArgumentException("Auditor array cannot be null or empty.");
        }
        this.setAuditors(Arrays.asList(auditors));
    }

    public MultiProviderAuditorProvider(Provider<Auditor>[] providers) {
        if (providers == null || providers.length == 0) {
            throw new IllegalArgumentException("Prover list cannot be null or empty.");
        }
        ArrayList<Auditor> auditors = new ArrayList<Auditor>();
        for (Provider<Auditor> provider : providers) {
            auditors.add((Auditor)provider.get());
        }
        this.setAuditors(auditors);
    }

    private void setAuditors(Collection<Auditor> auditors) {
        this.auditors = auditors;
    }

    public Auditor get() {
        return new MultiProviderAuditor(this.auditors);
    }
}

