/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.crypto.provider;

import com.google.inject.Provider;
import java.io.InputStream;
import javax.security.auth.callback.CallbackHandler;
import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.common.crypto.exceptions.CryptoException;
import org.nhindirect.common.crypto.impl.DynamicPKCS11TokenKeyStoreProtectionManager;

public class DynamicPKCS11TokenKeyStoreProtectionManagerProvider
implements Provider<KeyStoreProtectionManager> {
    private final String keyStorePassPhraseAlias;
    private final String privateKeyPassPhraseAlias;
    private final CallbackHandler handler;
    private final String keyStoreType;
    private final InputStream inputStream;

    public DynamicPKCS11TokenKeyStoreProtectionManagerProvider(String keyStorePassPhraseAlias, String privateKeyPassPhraseAlias, CallbackHandler handler) {
        this(keyStorePassPhraseAlias, privateKeyPassPhraseAlias, handler, null, null);
    }

    public DynamicPKCS11TokenKeyStoreProtectionManagerProvider(String keyStorePassPhraseAlias, String privateKeyPassPhraseAlias, CallbackHandler handler, String keyStoreType, InputStream inputStream) {
        this.keyStorePassPhraseAlias = keyStorePassPhraseAlias;
        this.privateKeyPassPhraseAlias = privateKeyPassPhraseAlias;
        this.handler = handler;
        this.keyStoreType = keyStoreType;
        this.inputStream = inputStream;
    }

    public KeyStoreProtectionManager get() {
        try {
            return new DynamicPKCS11TokenKeyStoreProtectionManager(this.keyStorePassPhraseAlias, this.privateKeyPassPhraseAlias, this.handler, this.keyStoreType, this.inputStream);
        }
        catch (CryptoException e) {
            throw new IllegalStateException("Failed to create DynamicPKCS11TokenKeyStoreProtectionManager.", e);
        }
    }
}

