/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.crypto.provider;

import com.google.inject.Provider;
import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.common.crypto.PKCS11Credential;
import org.nhindirect.common.crypto.exceptions.CryptoException;
import org.nhindirect.common.crypto.impl.StaticPKCS11TokenKeyStoreProtectionManager;

public class StaticPKCS11TokenKeyStoreProtectionManagerProvider
implements Provider<KeyStoreProtectionManager> {
    private final PKCS11Credential credential;
    private final String keyStorePassPhraseAlias;
    private final String privateKeyPassPhraseAlias;

    public StaticPKCS11TokenKeyStoreProtectionManagerProvider(PKCS11Credential credential, String keyStorePassPhraseAlias, String privateKeyPassPhraseAlias) {
        this.credential = credential;
        this.keyStorePassPhraseAlias = keyStorePassPhraseAlias;
        this.privateKeyPassPhraseAlias = privateKeyPassPhraseAlias;
    }

    public KeyStoreProtectionManager get() {
        try {
            return new StaticPKCS11TokenKeyStoreProtectionManager(this.credential, this.keyStorePassPhraseAlias, this.privateKeyPassPhraseAlias);
        }
        catch (CryptoException e) {
            throw new IllegalStateException("Failed to create StaticPKCS11TokenKeyStoreProtectionManager.", e);
        }
    }
}

