/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.rest;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.codehaus.jackson.map.ObjectMapper;
import org.nhindirect.common.rest.SecuredServiceRequestBase;
import org.nhindirect.common.rest.ServiceSecurityManager;
import org.nhindirect.common.rest.exceptions.ServiceException;

public abstract class AbstractPutRequest<T, E>
extends SecuredServiceRequestBase<E, ServiceException> {
    protected final T entity;

    protected AbstractPutRequest(HttpClient httpClient, String serviceUrl, ObjectMapper jsonMapper, ServiceSecurityManager securityManager, T entity) {
        super(httpClient, serviceUrl, jsonMapper, securityManager);
        this.entity = entity;
    }

    protected abstract String getRequestUri() throws ServiceException;

    @Override
    protected E interpretResponse(int statusCode, HttpResponse response) throws IOException, ServiceException {
        switch (statusCode) {
            case 200: 
            case 201: 
            case 204: {
                return (E)super.interpretResponse(statusCode, response);
            }
        }
        return (E)super.interpretResponse(statusCode, response);
    }

    @Override
    protected HttpUriRequest createRequest() throws IOException {
        try {
            HttpPut post = new HttpPut(this.getRequestUri());
            post.setHeader("Accept", "application/json");
            return (HttpUriRequest)this.buildEntityRequest(post, this.makeContent(), "application/json");
        }
        catch (ServiceException e) {
            throw new IOException("Error creating request URI.", e);
        }
    }

    protected byte[] makeContent() throws IOException {
        if (this.entity instanceof String) {
            return ((String)this.entity).getBytes();
        }
        if (this.entity instanceof byte[]) {
            return (byte[])this.entity;
        }
        return this.entity != null ? this.jsonMapper.writeValueAsBytes(this.entity) : new byte[]{};
    }

    @Override
    protected E parseResponse(HttpEntity response) throws IOException {
        return null;
    }
}

