/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.rest;

import java.io.IOException;
import org.apache.http.client.HttpClient;
import org.nhindirect.common.rest.AbstractUnsecuredService;
import org.nhindirect.common.rest.ServiceRequest;
import org.nhindirect.common.rest.ServiceSecurityManager;
import org.nhindirect.common.rest.exceptions.AuthException;
import org.nhindirect.common.rest.exceptions.ServiceException;

public abstract class AbstractSecuredService
extends AbstractUnsecuredService {
    protected final ServiceSecurityManager securityManager;

    public AbstractSecuredService(String serviceURL, HttpClient httpClient, ServiceSecurityManager securityManager) {
        super(serviceURL, httpClient);
        if (securityManager == null) {
            throw new IllegalArgumentException("Security manager cannot be null");
        }
        this.securityManager = securityManager;
    }

    @Override
    protected <T, E extends Exception> T callWithRetry(ServiceRequest<T, E> request) throws E, ServiceException {
        try {
            T t = new AuthRetryRequest<T, E>(request).call();
            return t;
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        finally {
            request.destroy();
        }
    }

    private class AuthRetryRequest<T, E extends Exception>
    implements ServiceRequest<T, E> {
        private final ServiceRequest<T, E> request;

        public AuthRetryRequest(ServiceRequest<T, E> other) {
            this.request = other;
        }

        @Override
        public T call() throws E, IOException, ServiceException {
            int retries = 1;
            while (true) {
                try {
                    return this.request.call();
                }
                catch (AuthException e) {
                    if (retries-- > 0) {
                        AbstractSecuredService.this.securityManager.authenticateSession();
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }

        @Override
        public void destroy() {
            this.request.destroy();
        }
    }
}

