/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.tx;

import java.util.Locale;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.common.tx.impl.DefaultTxDetailParser;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.common.tx.model.TxMessageType;

public class TxUtil {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(TxUtil.class);

    public static TxMessageType getMessageType(MimeMessage msg) {
        try {
            ContentType contentType = new ContentType(msg.getContentType());
            if (contentType.match("multipart/report") && contentType.getParameter("report-type") != null) {
                if (contentType.getParameter("report-type").equalsIgnoreCase("disposition-notification")) {
                    return TxMessageType.MDN;
                }
                if (contentType.getParameter("report-type").equalsIgnoreCase("delivery-status")) {
                    return TxMessageType.DSN;
                }
            } else if (contentType.match("application/pkcs7-mime") || contentType.match("application/x-pkcs7-mime")) {
                return TxMessageType.SMIME;
            }
            return TxMessageType.IMF;
        }
        catch (ParseException e) {
            LOGGER.warn((Object)"Failed to discern message type.", (Throwable)e);
        }
        catch (MessagingException e) {
            LOGGER.warn((Object)"Failed to discern message type.", (Throwable)e);
        }
        return TxMessageType.UNKNOWN;
    }

    public static boolean isReliableAndTimelyRequested(Tx imfMessage) {
        TxDetail dispositionOptionDetail;
        Map<String, TxDetail> details;
        boolean relAndTimelyRequired = false;
        if (imfMessage != null && !(details = imfMessage.getDetails()).isEmpty() && (dispositionOptionDetail = details.get(TxDetailType.DISPOSITION_OPTIONS.getType())) != null && dispositionOptionDetail.getDetailValue().toLowerCase(Locale.getDefault()).contains("X-DIRECT-FINAL-DESTINATION-DELIVERY".toLowerCase(Locale.getDefault()))) {
            relAndTimelyRequired = true;
        }
        return relAndTimelyRequired;
    }

    public static boolean isReliableAndTimelyRequested(MimeMessage msg) {
        if (msg == null) {
            return false;
        }
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        Map<String, TxDetail> details = parser.getMessageDetails(msg);
        Tx tx = new Tx(TxUtil.getMessageType(msg), details);
        return TxUtil.isReliableAndTimelyRequested(tx);
    }
}

