/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.tx.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.enunciate.json.JsonRootType;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.common.tx.model.TxMessageType;

@JsonRootType
public class Tx
implements Serializable {
    static final long serialVersionUID = -6462360991748031100L;
    protected TxMessageType msgType;
    protected Map<String, TxDetail> details;

    public Tx() {
        this.msgType = TxMessageType.UNKNOWN;
        this.details = new HashMap<String, TxDetail>();
    }

    public Tx(TxMessageType msgType, Map<String, TxDetail> details) {
        if (msgType == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        if (details == null) {
            throw new IllegalArgumentException("Details cannot be null");
        }
        this.details = Collections.unmodifiableMap(details);
        this.msgType = msgType;
    }

    public TxMessageType getMsgType() {
        return this.msgType;
    }

    public void setMsgType(TxMessageType type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        this.msgType = type;
    }

    public void setDetails(Map<String, TxDetail> details) {
        if (details == null) {
            throw new IllegalArgumentException("Details cannot be null");
        }
        this.details = details;
    }

    public Map<String, TxDetail> getDetails() {
        return this.details;
    }

    @JsonIgnore
    public TxDetail getDetail(TxDetailType detailType) {
        if (detailType == null) {
            return null;
        }
        return this.getDetail(detailType.getType());
    }

    @JsonIgnore
    public TxDetail getDetail(String detailName) {
        if (detailName == null || detailName.isEmpty()) {
            return null;
        }
        return this.details.get(detailName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("TxType: ").append(this.msgType.toString());
        if (this.details.isEmpty()) {
            builder.append("\r\nNo Details");
        } else {
            for (TxDetail detail : this.details.values()) {
                builder.append("\r\n\r\n").append(detail.toString());
            }
        }
        return builder.toString();
    }
}

