/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.mina.util.AvailablePortFinder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.dns.DNSServer;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSStore;
import org.nhindirect.dns.ProxyDNSStore;
import org.nhindirect.dns.util.IPUtils;
import org.xbill.DNS.Cache;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;

public class DNSConnectionTest {
    private static Collection<String> servers;
    private static int recType;
    private static String lookupRec;
    private static boolean useTCP;

    private static int getRecTypeFromArg(String arg) {
        int retVal = 1;
        if (arg.equalsIgnoreCase("A")) {
            retVal = 1;
        } else if (arg.equalsIgnoreCase("CERT")) {
            retVal = 37;
        } else if (arg.equalsIgnoreCase("SOA")) {
            retVal = 6;
        } else if (arg.equalsIgnoreCase("MX")) {
            retVal = 15;
        } else {
            System.err.println("Warning: Unsupported record type " + arg + ".  Defaulting to type A.");
        }
        return retVal;
    }

    public static void main(String[] argv) {
        if (argv.length == 0) {
            DNSConnectionTest.printUsage();
            System.exit(-1);
        }
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (!arg.startsWith("-")) {
                lookupRec = arg;
                continue;
            }
            if (arg.equalsIgnoreCase("-serv")) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing server list.");
                    System.exit(-1);
                }
                servers = Arrays.asList(argv[++i].split(","));
                continue;
            }
            if (arg.equals("-type")) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing record type.");
                    System.exit(-1);
                }
                recType = DNSConnectionTest.getRecTypeFromArg(argv[++i]);
                continue;
            }
            if (arg.equalsIgnoreCase("-useTCP")) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing TCP indicator");
                    System.exit(-1);
                }
                useTCP = Boolean.parseBoolean(argv[++i]);
                continue;
            }
            if (arg.equals("-help")) {
                DNSConnectionTest.printUsage();
                System.exit(-1);
                continue;
            }
            System.err.println("Error: Unknown argument " + arg + "\n");
            DNSConnectionTest.printUsage();
            System.exit(-1);
        }
        if (lookupRec == null) {
            System.err.println("Error: Missing record to lookup\n");
            DNSConnectionTest.printUsage();
            System.exit(-1);
        }
        try {
            DNSConnectionTest.performLookup();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private static void performLookup() throws Exception {
        Options.set((String)"verbose", (String)"true");
        Cache ch = Lookup.getDefaultCache((int)1);
        ch.clearCache();
        if (servers == null || servers.size() == 0) {
            servers = ResolverConfig.getCurrentConfig().servers().stream().map(addr -> addr.getHostString()).collect(Collectors.toList());
        }
        System.out.println("\r\nConfigure DNS resolvers:");
        for (String server : servers) {
            System.out.println("\t" + server);
        }
        System.out.println("\r\nLookup up record " + lookupRec);
        Lookup lu = new Lookup(new Name(lookupRec), recType);
        ExtendedResolver resolver = new ExtendedResolver(servers.toArray(new String[servers.size()]));
        resolver.setTCP(useTCP);
        lu.setResolver((Resolver)resolver);
        Record[] retRecords = lu.run();
        if (retRecords != null && retRecords.length > 0) {
            System.out.println(retRecords.length + " records found.");
        } else {
            System.out.println("No records found.");
        }
    }

    private static void printUsage() {
        StringBuffer use = new StringBuffer();
        use.append("Usage:\n");
        use.append("java DNSConnectionTest (options)...<record name>\n\n");
        use.append("options:\n");
        use.append("-serv   server\t\tList of DNS servers used for resolution\n");
        use.append("\t\t\tDefault: Currently configured DNS servers\n\n");
        use.append("-type   record type   Type of DNS record to lookup\n");
        use.append("\t\t\tDefault: A\n\n");
        use.append("-useTCP use TCP   Use TCP to connect to the DNS server\n");
        use.append("\t\t\tDefault: false\n\n");
        System.err.println(use);
    }

    @Test
    public void testDNSSocketConnectionTCPWithProxyStore() throws Exception {
        DNSServerSettings settings = new DNSServerSettings();
        settings.setPort(AvailablePortFinder.getNextAvailable((int)1024));
        DNSServer server = new DNSServer((DNSStore)new ProxyDNSStore(), settings);
        server.start();
        Thread.sleep(2000L);
        Options.set((String)"verbose", (String)"true");
        Lookup lu = new Lookup(new Name("google.com"), 1);
        ExtendedResolver resolver = new ExtendedResolver(IPUtils.getDNSLocalIps());
        resolver.setTCP(true);
        resolver.setPort(settings.getPort());
        lu.setResolver((Resolver)resolver);
        Record[] retRecords = lu.run();
        Assertions.assertNotNull((Object)retRecords);
        server.stop();
        Thread.sleep(2000L);
    }

    @Test
    public void testDNSSocketConnectionUDPWithProxyStore() throws Exception {
        DNSServerSettings settings = new DNSServerSettings();
        settings.setPort(AvailablePortFinder.getNextAvailable((int)1024));
        DNSServer server = new DNSServer((DNSStore)new ProxyDNSStore(), settings);
        server.start();
        Thread.sleep(2000L);
        Options.set((String)"verbose", (String)"true");
        Lookup lu = new Lookup(new Name("google.com"), 1);
        ExtendedResolver resolver = new ExtendedResolver(IPUtils.getDNSLocalIps());
        resolver.setTCP(false);
        resolver.setPort(settings.getPort());
        lu.setResolver((Resolver)resolver);
        Record[] retRecords = lu.run();
        Assertions.assertNotNull((Object)retRecords);
        server.stop();
        Thread.sleep(2000L);
    }

    static {
        recType = 1;
        useTCP = false;
    }
}

