/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.nhind.config.rest.CertPolicyService;
import org.nhind.config.rest.CertificateService;
import org.nhind.config.rest.DNSService;
import org.nhindirect.config.repository.AddressRepository;
import org.nhindirect.config.repository.AnchorRepository;
import org.nhindirect.config.repository.CertPolicyGroupDomainReltnRepository;
import org.nhindirect.config.repository.CertPolicyGroupRepository;
import org.nhindirect.config.repository.CertPolicyRepository;
import org.nhindirect.config.repository.CertificateRepository;
import org.nhindirect.config.repository.DNSRepository;
import org.nhindirect.config.repository.DomainRepository;
import org.nhindirect.config.repository.SettingRepository;
import org.nhindirect.config.repository.TrustBundleDomainReltnRepository;
import org.nhindirect.config.repository.TrustBundleRepository;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.RESTServiceDNSStore;
import org.nhindirect.dns.TestApplication;
import org.nhindirect.dns.service.DNSServerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@SpringBootTest(classes={TestApplication.class}, webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT)
@TestPropertySource(value={"classpath:bootstrap.properties"})
public abstract class SpringBaseTest {
    protected String filePrefix;
    @Autowired
    protected CertificateService certService;
    @Autowired
    protected CertPolicyService certPolService;
    @Autowired
    protected DNSService dnsService;
    @Autowired
    protected AddressRepository addressRepo;
    @Autowired
    protected TrustBundleRepository bundleRepo;
    @Autowired
    protected TrustBundleDomainReltnRepository bundleDomainRepo;
    @Autowired
    protected DomainRepository domainRepo;
    @Autowired
    protected AnchorRepository anchorRepo;
    @Autowired
    protected CertificateRepository certRepo;
    @Autowired
    protected DNSRepository dnsRepo;
    @Autowired
    protected SettingRepository settingRepo;
    @Autowired
    protected CertPolicyRepository policyRepo;
    @Autowired
    protected CertPolicyGroupRepository policyGroupRepo;
    @Autowired
    protected CertPolicyGroupDomainReltnRepository groupReltnRepo;
    @Autowired
    protected DNSServerService dnsServer;
    @Autowired
    protected RESTServiceDNSStore dnsStore;
    @Autowired
    protected DNSServerSettings settings;

    @BeforeEach
    public void setUp() {
        File file = new File("./src/test/resources/bundles/signedbundle.p7b");
        this.filePrefix = file.getAbsolutePath().contains(":/") ? "file:///" : "file:///";
        try {
            this.cleanDataStore();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        File dir = new File("./target/tempFiles");
        if (dir.exists()) {
            try {
                FileUtils.cleanDirectory((File)dir);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @AfterEach
    public void shutdown() throws Exception {
        this.dnsServer.stopService();
    }

    protected void cleanDataStore() throws Exception {
        this.anchorRepo.deleteAll().block();
        this.groupReltnRepo.deleteAll().block();
        this.addressRepo.deleteAll().block();
        this.bundleDomainRepo.deleteAll().block();
        this.bundleRepo.deleteAll().block();
        this.domainRepo.deleteAll().block();
        this.policyGroupRepo.deleteAll().block();
        this.policyRepo.deleteAll().block();
        this.certRepo.deleteAll().block();
        this.dnsRepo.deleteAll().block();
        this.settingRepo.deleteAll().block();
    }
}

