/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns;

import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.config.model.CertPolicy;
import org.nhindirect.config.model.Certificate;
import org.nhindirect.config.model.DNSRecord;
import org.nhindirect.dns.SpringBaseTest;
import org.nhindirect.dns.util.BaseTestPlan;
import org.nhindirect.dns.util.DNSRecordUtil;
import org.nhindirect.dns.util.IPUtils;
import org.nhindirect.policy.PolicyLexicon;
import org.xbill.DNS.CERTRecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;

public class DNSServer_Function_Test
extends SpringBaseTest {
    static final String KEY_ENC_POLICY = "(X509.TBS.EXTENSION.KeyUsage & 32) > 0";

    private Certificate xCertToCert(X509Certificate cert) throws Exception {
        Certificate retVal = new Certificate();
        retVal.setOwner(CryptoExtensions.getSubjectAddress((X509Certificate)cert));
        retVal.setData(cert.getEncoded());
        return retVal;
    }

    @Test
    public void testQueryARecord_AssertRecordsRetrieved_NoSOA() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DNSRecord> recs = new ArrayList<DNSRecord>();
                DNSRecord rec = DNSRecordUtil.createARecord("example.domain.com", "127.0.0.1");
                recs.add(rec);
                rec = DNSRecordUtil.createARecord("example2.domain.com", "127.0.0.1");
                recs.add(rec);
                for (DNSRecord addRec : recs) {
                    DNSServer_Function_Test.this.dnsService.addDNSRecord(addRec);
                }
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("example2.domain.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assertions.assertNotNull(records);
                Assertions.assertEquals((int)1, (int)records.size());
                Assertions.assertEquals((Object)"example2.domain.com.", (Object)records.iterator().next().getName().toString());
            }
        }.perform();
    }

    @Test
    public void testQueryARecord_AssertRecordsRetrieved_SOARecord() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DNSRecord> recs = new ArrayList<DNSRecord>();
                DNSRecord rec = DNSRecordUtil.createARecord("example.domain.com", "127.0.0.1");
                recs.add(rec);
                rec = DNSRecordUtil.createARecord("example2.domain.com", "127.0.0.1");
                recs.add(rec);
                rec = DNSRecordUtil.createARecord("sub2.example2.domain.com", "127.0.0.1");
                recs.add(rec);
                rec = DNSRecordUtil.createSOARecord("domain.com", "nsserver.domain.com", "master.domain.com");
                recs.add(rec);
                for (DNSRecord addRec : recs) {
                    DNSServer_Function_Test.this.dnsService.addDNSRecord(addRec);
                }
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("sub2.example2.domain.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assertions.assertNotNull(records);
                Assertions.assertEquals((int)1, (int)records.size());
                Assertions.assertEquals((Object)"sub2.example2.domain.com.", (Object)records.iterator().next().getName().toString());
            }
        }.perform();
    }

    @Test
    public void testQueryARecordByAny_AssertRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DNSRecord> recs = new ArrayList<DNSRecord>();
                DNSRecord rec = DNSRecordUtil.createARecord("example.domain.com", "127.0.0.1");
                recs.add(rec);
                rec = DNSRecordUtil.createARecord("example2.domain.com", "127.0.0.1");
                recs.add(rec);
                for (DNSRecord addRec : recs) {
                    DNSServer_Function_Test.this.dnsService.addDNSRecord(addRec);
                }
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("example2.domain.com", 255));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assertions.assertNotNull(records);
                Assertions.assertEquals((int)1, (int)records.size());
                Assertions.assertEquals((Object)"example2.domain.com.", (Object)records.iterator().next().getName().toString());
            }
        }.perform();
    }

    @Test
    public void testQueryMutliARecords_AssertRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DNSRecord> recs = new ArrayList<DNSRecord>();
                DNSRecord rec = DNSRecordUtil.createARecord("example.domain.com", "127.0.0.1");
                recs.add(rec);
                rec = DNSRecordUtil.createARecord("example.domain.com", "127.0.0.2");
                recs.add(rec);
                rec = DNSRecordUtil.createSOARecord("domain.com", "nsserver.domain.com", "master.domain.com");
                recs.add(rec);
                for (DNSRecord addRec : recs) {
                    DNSServer_Function_Test.this.dnsService.addDNSRecord(addRec);
                }
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("example.domain.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assertions.assertNotNull(records);
                Assertions.assertEquals((int)2, (int)records.size());
                Assertions.assertEquals((Object)"example.domain.com.", (Object)records.iterator().next().getName().toString());
            }
        }.perform();
    }

    @Test
    public void testQueryARecords_AssertNoRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("example.domain.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assertions.assertNotNull(records);
                Assertions.assertEquals((int)0, (int)records.size());
            }
        }.perform();
    }

    @Test
    public void testAnyQueryType_multipleTypesInRecord_AssertRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DNSRecord> recs = new ArrayList<DNSRecord>();
                DNSRecord rec = DNSRecordUtil.createARecord("example.domain.com", "127.0.0.1");
                recs.add(rec);
                rec = DNSRecordUtil.createARecord("example.domain.com", "127.0.0.2");
                recs.add(rec);
                rec = DNSRecordUtil.createMXRecord("example.domain.com", "domain.com", 1);
                recs.add(rec);
                for (DNSRecord addRec : recs) {
                    DNSServer_Function_Test.this.dnsService.addDNSRecord(addRec);
                }
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("example.domain.com", 255));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assertions.assertNotNull(records);
                Assertions.assertEquals((int)3, (int)records.size());
                Assertions.assertEquals((Object)"example.domain.com.", (Object)records.iterator().next().getName().toString());
            }
        }.perform();
    }

    @Test
    public void testQueryCERTRecords_AssertRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<Certificate> recs = new ArrayList<Certificate>();
                X509Certificate cert = DNSRecordUtil.loadCertificate("bob.der");
                Certificate addCert = DNSServer_Function_Test.this.xCertToCert(cert);
                recs.add(addCert);
                cert = DNSRecordUtil.loadCertificate("gm2552.der");
                addCert = DNSServer_Function_Test.this.xCertToCert(cert);
                recs.add(addCert);
                cert = DNSRecordUtil.loadCertificate("ryan.der");
                addCert = DNSServer_Function_Test.this.xCertToCert(cert);
                recs.add(addCert);
                for (Certificate addCertRec : recs) {
                    DNSServer_Function_Test.this.certService.addCertificate(addCertRec);
                }
                ArrayList<DNSRecord> soaRecs = new ArrayList<DNSRecord>();
                DNSRecord rec = DNSRecordUtil.createSOARecord("securehealthemail.com", "nsserver.securehealthemail.com", "master.securehealthemail.com");
                soaRecs.add(rec);
                for (DNSRecord addRec : soaRecs) {
                    DNSServer_Function_Test.this.dnsService.addDNSRecord(addRec);
                }
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("gm2552.securehealthemail.com", 37));
                queries.add(new Query("ryan.securehealthemail.com", 255));
                queries.add(new Query("bob.somewhere.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assertions.assertNotNull(records);
                Assertions.assertEquals((int)2, (int)records.size());
                boolean foundGreg = false;
                boolean foundRyan = false;
                for (Record record : records) {
                    Assertions.assertTrue((boolean)(record instanceof CERTRecord));
                    X509Certificate cert = (X509Certificate)DNSRecordUtil.parseRecord((CERTRecord)record);
                    Assertions.assertNotNull((Object)cert);
                    if (cert.getSubjectDN().toString().contains("gm2552@securehealthemail.com")) {
                        foundGreg = true;
                        continue;
                    }
                    if (!cert.getSubjectDN().toString().contains("ryan@securehealthemail.com")) continue;
                    foundRyan = true;
                }
                Assertions.assertTrue((boolean)foundGreg);
                Assertions.assertTrue((boolean)foundRyan);
            }
        }.perform();
    }

    @Test
    public void testQueryCERTRecords_policyExists_AssertRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            public void tearDownMocks() throws Exception {
                DNSServer_Function_Test.this.dnsStore.setCertPolicyName("");
            }

            @Override
            protected void setupMocks() throws Exception {
                CertPolicy policy = new CertPolicy();
                policy.setLexicon(PolicyLexicon.SIMPLE_TEXT_V1);
                policy.setPolicyName("ValidPolicy");
                policy.setPolicyData(DNSServer_Function_Test.KEY_ENC_POLICY.getBytes());
                DNSServer_Function_Test.this.certPolService.addPolicy(policy);
                this.addRecords();
                DNSServer_Function_Test.this.dnsServer.startServer();
                DNSServer_Function_Test.this.dnsStore.setCertPolicyName("ValidPolicy");
            }

            @Override
            protected void addRecords() throws Exception {
                ArrayList<Certificate> recs = new ArrayList<Certificate>();
                X509Certificate cert = DNSRecordUtil.loadCertificate("bob.der");
                Certificate addCert = DNSServer_Function_Test.this.xCertToCert(cert);
                recs.add(addCert);
                cert = DNSRecordUtil.loadCertificate("umesh.der");
                addCert = DNSServer_Function_Test.this.xCertToCert(cert);
                recs.add(addCert);
                for (Certificate addRec : recs) {
                    DNSServer_Function_Test.this.certService.addCertificate(addRec);
                }
                ArrayList<DNSRecord> soaRecs = new ArrayList<DNSRecord>();
                DNSRecord rec = DNSRecordUtil.createSOARecord("securehealthemail.com", "nsserver.securehealthemail.com", "master.securehealthemail.com");
                soaRecs.add(rec);
                rec = DNSRecordUtil.createSOARecord("nhind.hsgincubator.com", "nsserver.nhind.hsgincubator.com", "master.nhind.hsgincubator.com");
                soaRecs.add(rec);
                for (DNSRecord addSoaRec : soaRecs) {
                    DNSServer_Function_Test.this.dnsService.addDNSRecord(addSoaRec);
                }
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("bob.nhind.hsgincubator.com", 37));
                queries.add(new Query("umesh.securehealthemail.com", 37));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assertions.assertNotNull(records);
                Assertions.assertEquals((int)1, (int)records.size());
                Record record = records.iterator().next();
                Assertions.assertTrue((boolean)(record instanceof CERTRecord));
                X509Certificate cert = (X509Certificate)DNSRecordUtil.parseRecord((CERTRecord)record);
                Assertions.assertNotNull((Object)cert);
                CryptoExtensions.getSubjectAddress((X509Certificate)cert).equals("bob@nhind.hsgincubator.com");
            }
        }.perform();
    }

    @Test
    public void testQueryCERTRecords_AssertNoRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("gm2552.securehealthemail.com", 37));
                queries.add(new Query("ryan.securehealthemail.com", 255));
                queries.add(new Query("bob.somewhere.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assertions.assertNotNull(records);
                Assertions.assertEquals((int)0, (int)records.size());
            }
        }.perform();
    }

    @Test
    public void testQueryMXRecord_AssertRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DNSRecord> recs = new ArrayList<DNSRecord>();
                DNSRecord rec = DNSRecordUtil.createMXRecord("domain.com", "example.domain.com", 1);
                recs.add(rec);
                rec = DNSRecordUtil.createMXRecord("domain.com", "example2.domain.com", 2);
                recs.add(rec);
                rec = DNSRecordUtil.createMXRecord("domain2.com", "example.domain2.com", 1);
                recs.add(rec);
                for (DNSRecord addRec : recs) {
                    DNSServer_Function_Test.this.dnsService.addDNSRecord(addRec);
                }
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("domain.com", 15));
                queries.add(new Query("domain.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assertions.assertNotNull(records);
                Assertions.assertEquals((int)2, (int)records.size());
                Assertions.assertEquals((Object)"domain.com.", (Object)records.iterator().next().getName().toString());
            }
        }.perform();
    }

    @Test
    public void testQueryMXRecordByA_AssertNoRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DNSRecord> recs = new ArrayList<DNSRecord>();
                DNSRecord rec = DNSRecordUtil.createMXRecord("domain.com", "example.domain.com", 1);
                recs.add(rec);
                rec = DNSRecordUtil.createMXRecord("domain.com", "example2.domain.com", 2);
                recs.add(rec);
                rec = DNSRecordUtil.createMXRecord("domain2.com", "example.domain2.com", 1);
                recs.add(rec);
                for (DNSRecord addRec : recs) {
                    DNSServer_Function_Test.this.dnsService.addDNSRecord(addRec);
                }
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("domain.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assertions.assertNotNull(records);
                Assertions.assertEquals((int)0, (int)records.size());
            }
        }.perform();
    }

    @Test
    public void testQueryNSRecord_AssertRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DNSRecord> recs = new ArrayList<DNSRecord>();
                DNSRecord rec = DNSRecordUtil.createNSRecord("domain.com", "ns.domain.com");
                recs.add(rec);
                rec = DNSRecordUtil.createNSRecord("domain.com", "ns2.domain.com");
                recs.add(rec);
                rec = DNSRecordUtil.createNSRecord("domain2.com", "ns.domain2.com");
                recs.add(rec);
                for (DNSRecord addRec : recs) {
                    DNSServer_Function_Test.this.dnsService.addDNSRecord(addRec);
                }
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("domain.com", 2));
                queries.add(new Query("domain.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assertions.assertNotNull(records);
                Assertions.assertEquals((int)2, (int)records.size());
                Assertions.assertEquals((Object)"domain.com.", (Object)records.iterator().next().getName().toString());
                for (Record rec : records) {
                    Assertions.assertEquals((int)2, (int)rec.getType());
                }
            }
        }.perform();
    }

    @Test
    public void testQueryNSRecordByA_AssertNoRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DNSRecord> recs = new ArrayList<DNSRecord>();
                DNSRecord rec = DNSRecordUtil.createNSRecord("domain.com", "ns.domain.com");
                recs.add(rec);
                rec = DNSRecordUtil.createNSRecord("domain.com", "ns2.domain.com");
                recs.add(rec);
                rec = DNSRecordUtil.createNSRecord("domain2.com", "ns.domain2.com");
                recs.add(rec);
                for (DNSRecord addRec : recs) {
                    DNSServer_Function_Test.this.dnsService.addDNSRecord(addRec);
                }
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("domain.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assertions.assertNotNull(records);
                Assertions.assertEquals((int)0, (int)records.size());
            }
        }.perform();
    }

    @Test
    public void testQueryCNAMERecord_AssertRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DNSRecord> recs = new ArrayList<DNSRecord>();
                DNSRecord rec = DNSRecordUtil.createCNAMERecord("domainserver.com", "domain.com");
                recs.add(rec);
                rec = DNSRecordUtil.createCNAMERecord("domainserver2.com", "domain.com");
                recs.add(rec);
                rec = DNSRecordUtil.createCNAMERecord("domain2server.com", "domain2.com");
                recs.add(rec);
                for (DNSRecord addRec : recs) {
                    DNSServer_Function_Test.this.dnsService.addDNSRecord(addRec);
                }
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("domainserver.com", 5));
                queries.add(new Query("domainserver2.com", 5));
                queries.add(new Query("domain.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assertions.assertNotNull(records);
                Assertions.assertEquals((int)2, (int)records.size());
                Assertions.assertEquals((Object)"domainserver.com.", (Object)records.iterator().next().getName().toString());
                for (Record rec : records) {
                    Assertions.assertEquals((int)5, (int)rec.getType());
                }
            }
        }.perform();
    }

    @Test
    public void testQueryCNAMERecordByA_AssertNoRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DNSRecord> recs = new ArrayList<DNSRecord>();
                DNSRecord rec = DNSRecordUtil.createCNAMERecord("domainserver.com", "domain.com");
                recs.add(rec);
                rec = DNSRecordUtil.createCNAMERecord("domainserver2.com", "domain.com");
                recs.add(rec);
                rec = DNSRecordUtil.createCNAMERecord("domain2server.com", "domain2.com");
                recs.add(rec);
                for (DNSRecord addRec : recs) {
                    DNSServer_Function_Test.this.dnsService.addDNSRecord(addRec);
                }
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("domain.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assertions.assertNotNull(records);
                Assertions.assertEquals((int)0, (int)records.size());
            }
        }.perform();
    }

    @Test
    public void testQueryTXTRecord_AssertRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DNSRecord> recs = new ArrayList<DNSRecord>();
                DNSRecord rec = DNSRecordUtil.createTXTRecord("domain.com", "ns.domain.com");
                recs.add(rec);
                rec = DNSRecordUtil.createTXTRecord("domain.com", "ns2.domain.com");
                recs.add(rec);
                rec = DNSRecordUtil.createTXTRecord("domain2.com", "ns.domain2.com");
                recs.add(rec);
                for (DNSRecord addRec : recs) {
                    DNSServer_Function_Test.this.dnsService.addDNSRecord(addRec);
                }
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("domain.com", 16));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assertions.assertNotNull(records);
                Assertions.assertEquals((int)2, (int)records.size());
                for (Record rec : records) {
                    Assertions.assertEquals((int)16, (int)rec.getType());
                    Assertions.assertEquals((Object)"domain.com.", (Object)rec.getName().toString());
                }
            }
        }.perform();
    }

    @Test
    public void testQueryCAARecord_AssertRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DNSRecord> recs = new ArrayList<DNSRecord>();
                DNSRecord rec = DNSRecordUtil.createTXTRecord("domain.com", "ns.domain.com");
                recs.add(rec);
                rec = DNSRecordUtil.createTXTRecord("domain.com", "ns2.domain.com");
                recs.add(rec);
                rec = DNSRecordUtil.createTXTRecord("domain2.com", "ns.domain2.com");
                recs.add(rec);
                for (DNSRecord addRec : recs) {
                    DNSServer_Function_Test.this.dnsService.addDNSRecord(addRec);
                }
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("domain.com", 16));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assertions.assertNotNull(records);
                Assertions.assertEquals((int)2, (int)records.size());
                for (Record rec : records) {
                    Assertions.assertEquals((int)16, (int)rec.getType());
                    Assertions.assertEquals((Object)"domain.com.", (Object)rec.getName().toString());
                }
            }
        }.perform();
    }

    @Test
    public void testQueryUnsupportedQueryType() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DNSRecord> recs = new ArrayList<DNSRecord>();
                DNSRecord rec = DNSRecordUtil.createCNAMERecord("domainserver.com", "domain.com");
                recs.add(rec);
                DNSServer_Function_Test.this.dnsService.addDNSRecord(rec);
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("domain.com", 28));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assertions.assertNotNull(records);
                Assertions.assertEquals((int)0, (int)records.size());
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        TestPlan() {
        }

        @Override
        protected void setupMocks() throws Exception {
            this.addRecords();
            DNSServer_Function_Test.this.dnsServer.startServer();
        }

        @Override
        protected void tearDownMocks() throws Exception {
            if (DNSServer_Function_Test.this.dnsServer != null) {
                DNSServer_Function_Test.this.dnsServer.stopService();
            }
        }

        @Override
        protected void performInner() throws Exception {
            ExtendedResolver resolver = new ExtendedResolver(IPUtils.getDNSLocalIps());
            resolver.setTimeout(Duration.ofSeconds(300L));
            resolver.setTCP(true);
            resolver.setPort(DNSServer_Function_Test.this.settings.getPort());
            ArrayList<Record> retrievedRecord = new ArrayList<Record>();
            Collection<Query> queries = this.getTestQueries();
            for (Query query : queries) {
                Lookup lu = new Lookup(new Name(query.name), query.type);
                Cache ch = Lookup.getDefaultCache((int)1);
                ch.clearCache();
                lu.setResolver((Resolver)resolver);
                Record[] retRecords = lu.run();
                if (retRecords == null || retRecords.length <= 0) continue;
                retrievedRecord.addAll(Arrays.asList(retRecords));
            }
            this.doAssertions(retrievedRecord);
        }

        protected abstract void addRecords() throws Exception;

        protected abstract Collection<Query> getTestQueries() throws Exception;

        protected abstract void doAssertions(Collection<Record> var1) throws Exception;
    }

    private static class Query {
        public String name;
        public int type;

        public Query(String name, int type) {
            this.name = name;
            this.type = type;
        }
    }
}

