/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.config.model.CertPolicy;
import org.nhindirect.dns.SpringBaseTest;
import org.nhindirect.policy.PolicyLexicon;

public class RESTServiceDNSStore_configCertPolicyTest
extends SpringBaseTest {
    static final String VALID_POLICY = "(X509.TBS.EXTENSION.KeyUsage & 32) > 0";
    static final String INVALID_VALID_POLICY = "(X509.TBS.EXTENSION.KeyUsage4fds & | 32) > 0";

    @Test
    public void testConfigCertPolicy_policyDoesNotExists_assertNoPolicyConfiged() throws Exception {
        Assertions.assertNull((Object)this.dnsStore.polExpression);
        Assertions.assertNull((Object)this.dnsStore.polFilter);
    }

    @Test
    public void testConfigCertPolicy_invalidPolicy_assertNoPolicyConfiged() throws Exception {
        try {
            CertPolicy policy = new CertPolicy();
            policy.setLexicon(PolicyLexicon.SIMPLE_TEXT_V1);
            policy.setPolicyName("InvalidPolicy");
            policy.setPolicyData(INVALID_VALID_POLICY.getBytes());
            this.certPolService.addPolicy(policy);
            this.dnsStore.setCertPolicyName("InvalidPolicy");
            Assertions.assertNull((Object)this.dnsStore.polExpression);
            Assertions.assertNull((Object)this.dnsStore.polFilter);
        }
        finally {
            this.dnsStore.setCertPolicyName("");
        }
    }

    @Test
    public void testConfigCertPolicy_validPolicy_assertPolicyConfiged() throws Exception {
        try {
            CertPolicy policy = new CertPolicy();
            policy.setLexicon(PolicyLexicon.SIMPLE_TEXT_V1);
            policy.setPolicyName("ValidPolicy");
            policy.setPolicyData(VALID_POLICY.getBytes());
            this.certPolService.addPolicy(policy);
            this.dnsStore.setCertPolicyName("ValidPolicy");
            Assertions.assertNotNull((Object)this.dnsStore.polExpression);
            Assertions.assertNotNull((Object)this.dnsStore.polFilter);
        }
        finally {
            this.dnsStore.setCertPolicyName("");
        }
    }
}

