/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns;

import java.security.cert.X509Certificate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.nhindirect.config.model.CertPolicy;
import org.nhindirect.dns.SpringBaseTest;
import org.nhindirect.dns.util.DNSRecordUtil;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.policy.PolicyFilter;
import org.nhindirect.policy.PolicyLexicon;

public class RESTServiceDNSStore_isCertCompliantWithPolicyTest
extends SpringBaseTest {
    static final String KEY_ENC_POLICY = "(X509.TBS.EXTENSION.KeyUsage & 32) > 0";

    @Test
    public void testisCertCompliantWithPolicy_noPolicyConfigured_assertCompliant() throws Exception {
        Assertions.assertNull((Object)this.dnsStore.polExpression);
        Assertions.assertNull((Object)this.dnsStore.polFilter);
        X509Certificate cert = DNSRecordUtil.loadCertificate("bob.der");
        Assertions.assertTrue((boolean)this.dnsStore.isCertCompliantWithPolicy(cert));
    }

    @Test
    public void testisCertCompliantWithPolicy_policyConfigured_compliantCert_assertCompliant() throws Exception {
        try {
            CertPolicy policy = new CertPolicy();
            policy.setLexicon(PolicyLexicon.SIMPLE_TEXT_V1);
            policy.setPolicyName("ValidPolicy");
            policy.setPolicyData(KEY_ENC_POLICY.getBytes());
            this.certPolService.addPolicy(policy);
            this.dnsStore.setCertPolicyName("ValidPolicy");
            Assertions.assertNotNull((Object)this.dnsStore.polExpression);
            Assertions.assertNotNull((Object)this.dnsStore.polFilter);
            X509Certificate cert = DNSRecordUtil.loadCertificate("bob.der");
            Assertions.assertTrue((boolean)this.dnsStore.isCertCompliantWithPolicy(cert));
        }
        finally {
            this.dnsStore.setCertPolicyName("");
        }
    }

    @Test
    public void testisCertCompliantWithPolicy_policyConfigured_nonCompliantCert_assertNonCompliant() throws Exception {
        try {
            CertPolicy policy = new CertPolicy();
            policy.setLexicon(PolicyLexicon.SIMPLE_TEXT_V1);
            policy.setPolicyName("ValidPolicy");
            policy.setPolicyData(KEY_ENC_POLICY.getBytes());
            this.certPolService.addPolicy(policy);
            this.dnsStore.setCertPolicyName("ValidPolicy");
            Assertions.assertNotNull((Object)this.dnsStore.polExpression);
            Assertions.assertNotNull((Object)this.dnsStore.polFilter);
            X509Certificate cert = DNSRecordUtil.loadCertificate("umesh.der");
            Assertions.assertFalse((boolean)this.dnsStore.isCertCompliantWithPolicy(cert));
        }
        finally {
            this.dnsStore.setCertPolicyName("");
        }
    }

    @Test
    public void testisCertCompliantWithPolicy_exceptionInFilter_assertCompliant() throws Exception {
        PolicyFilter filt = (PolicyFilter)Mockito.mock(PolicyFilter.class);
        ((PolicyFilter)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Just Passing Through")}).when((Object)filt)).isCompliant((X509Certificate)ArgumentMatchers.any(), (PolicyExpression)ArgumentMatchers.any());
        this.dnsStore.polFilter = filt;
        X509Certificate cert = DNSRecordUtil.loadCertificate("umesh.der");
        Assertions.assertTrue((boolean)this.dnsStore.isCertCompliantWithPolicy(cert));
    }
}

