/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.nhindirect.config.model.DNSRecord;
import org.nhindirect.config.store.util.DNSRecordUtils;
import org.xbill.DNS.CERTRecord;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.TXTRecord;

public class DNSRecordUtil {
    private static final String certBasePath = "src/test/resources/certs/";

    private static DNSRecord toDnsRecord(org.nhindirect.config.store.DNSRecord rec) {
        DNSRecord retVal = new DNSRecord();
        retVal.setData(rec.getData());
        retVal.setDclass(rec.getDclass());
        retVal.setName(rec.getName());
        retVal.setTtl(rec.getTtl());
        retVal.setType(rec.getType());
        return retVal;
    }

    public static X509Certificate loadCertificate(String certFileName) throws Exception {
        File fl = new File(certBasePath + certFileName);
        ByteArrayInputStream str = new ByteArrayInputStream(FileUtils.readFileToByteArray((File)fl));
        X509Certificate retVal = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(str);
        ((InputStream)str).close();
        return retVal;
    }

    public static DNSRecord createARecord(String name, String ip) throws Exception {
        org.nhindirect.config.store.DNSRecord rec = DNSRecordUtils.createARecord((String)name, (long)86400L, (String)ip);
        return DNSRecordUtil.toDnsRecord(rec);
    }

    public static DNSRecord createCERTRecord(String name, X509Certificate cert) throws Exception {
        org.nhindirect.config.store.DNSRecord rec = DNSRecordUtils.createX509CERTRecord((String)name, (long)86400L, (X509Certificate)cert);
        return DNSRecordUtil.toDnsRecord(rec);
    }

    public static DNSRecord createMXRecord(String name, String target, int priority) throws Exception {
        org.nhindirect.config.store.DNSRecord rec = DNSRecordUtils.createMXRecord((String)name, (String)target, (long)86400L, (int)priority);
        return DNSRecordUtil.toDnsRecord(rec);
    }

    public static DNSRecord createSOARecord(String name, String nameServer, String hostmaster) throws Exception {
        org.nhindirect.config.store.DNSRecord rec = DNSRecordUtils.createSOARecord((String)name, (long)3600L, (String)nameServer, (String)hostmaster, (int)1, (long)3600L, (long)600L, (long)604800L, (long)3600L);
        return DNSRecordUtil.toDnsRecord(rec);
    }

    public static DNSRecord createNSRecord(String name, String target) throws Exception {
        if (!name.endsWith(".")) {
            name = name + ".";
        }
        if (!target.endsWith(".")) {
            target = target + ".";
        }
        NSRecord rec = new NSRecord(Name.fromString((String)name), 1, 86400L, Name.fromString((String)target));
        return DNSRecordUtil.toDnsRecord(org.nhindirect.config.store.DNSRecord.fromWire((byte[])rec.toWireCanonical()));
    }

    public static DNSRecord createCNAMERecord(String name, String target) throws Exception {
        if (!name.endsWith(".")) {
            name = name + ".";
        }
        if (!target.endsWith(".")) {
            target = target + ".";
        }
        CNAMERecord rec = new CNAMERecord(Name.fromString((String)name), 1, 86400L, Name.fromString((String)target));
        return DNSRecordUtil.toDnsRecord(org.nhindirect.config.store.DNSRecord.fromWire((byte[])rec.toWireCanonical()));
    }

    public static DNSRecord createTXTRecord(String name, String text) throws Exception {
        if (!name.endsWith(".")) {
            name = name + ".";
        }
        if (StringUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("Text cannot be empty.");
        }
        TXTRecord rec = new TXTRecord(Name.fromString((String)name), 1, 300L, text);
        return DNSRecordUtil.toDnsRecord(org.nhindirect.config.store.DNSRecord.fromWire((byte[])rec.toWireCanonical()));
    }

    public static Certificate parseRecord(CERTRecord r) {
        int type = r.getCertType();
        byte[] data = r.getCert();
        try {
            switch (type) {
                case 1: {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    ByteArrayInputStream bs = new ByteArrayInputStream(data);
                    Certificate cert = cf.generateCertificate(bs);
                    return cert;
                }
            }
            return null;
        }
        catch (CertificateException var6) {
            return null;
        }
    }
}

