/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns;

import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.nhindirect.dns.DNSError;
import org.nhindirect.dns.DNSException;
import org.nhindirect.dns.DNSStore;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.policy.PolicyFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Header;
import org.xbill.DNS.InvalidTypeException;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.Type;

public abstract class AbstractDNSStore
implements DNSStore {
    private static final Logger log = LoggerFactory.getLogger(AbstractDNSStore.class);
    protected static final String DNS_CERT_POLICY_NAME_VAR = "org.nhindirect.dns.CertPolicyName";
    protected static final String DEFAULT_JCE_PROVIDER_STRING = "BC";
    protected static final String JCE_PROVIDER_STRING_SYS_PARAM = "org.nhindirect.dns.JCEProviderName";
    protected Map<String, Record> soaRecords = null;
    protected PolicyFilter polFilter = null;
    protected PolicyExpression polExpression = null;

    public static String getJCEProviderName() {
        String retVal = System.getProperty(JCE_PROVIDER_STRING_SYS_PARAM);
        if (retVal == null || retVal.isEmpty()) {
            retVal = DEFAULT_JCE_PROVIDER_STRING;
        }
        return retVal;
    }

    public static void setJCEProviderName(String name) {
        if (name == null || name.isEmpty()) {
            System.setProperty(JCE_PROVIDER_STRING_SYS_PARAM, DEFAULT_JCE_PROVIDER_STRING);
        } else {
            System.setProperty(JCE_PROVIDER_STRING_SYS_PARAM, name);
        }
    }

    @Override
    public Message get(Message request) throws DNSException {
        log.trace("get(Message) Entered");
        if (request == null) {
            throw new DNSException(DNSError.newError(1));
        }
        Header header = request.getHeader();
        if (header.getFlag(0) || header.getRcode() != 0) {
            throw new DNSException(DNSError.newError(1));
        }
        if (header.getOpcode() != 0) {
            throw new DNSException(DNSError.newError(4));
        }
        Record queryRecord = request.getQuestion();
        if (queryRecord == null || queryRecord.getDClass() != 1) {
            throw new DNSException(DNSError.newError(4));
        }
        Name name = queryRecord.getName();
        int type = queryRecord.getType();
        String typeString = null;
        try {
            typeString = Type.string((int)type);
        }
        catch (InvalidTypeException invalidTypeException) {
            // empty catch block
        }
        if (log.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("Received Query Request:");
            builder.append("\r\n\tName: " + name.toString());
            builder.append("\r\n\tType: " + (typeString == null ? Integer.valueOf(type) : typeString));
            builder.append("\r\n\tDClass: " + queryRecord.getDClass());
            log.debug(builder.toString());
        }
        log.info("Process record for DNS request type " + (typeString == null ? Integer.valueOf(type) : typeString) + " and name " + name.toString());
        List lookupRecords = null;
        switch (type) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 15: 
            case 16: 
            case 33: 
            case 257: {
                RRset set;
                try {
                    set = this.processGenericRecordRequest(name.toString(), type);
                    if (set == null) break;
                    lookupRecords = set.rrs();
                    break;
                }
                catch (Exception e) {
                    throw new DNSException(DNSError.newError(2), "DNS service proxy call failed: " + e.getMessage(), e);
                }
            }
            case 37: {
                RRset set = this.processCERTRecordRequest(name.toString());
                if (set == null) break;
                lookupRecords = set.rrs();
                break;
            }
            case 255: {
                Collection<Record> genRecs = this.processGenericANYRecordRequest(name.toString());
                RRset certRecs = this.processCERTRecordRequest(name.toString());
                if (genRecs == null && certRecs == null) break;
                lookupRecords = new ArrayList<Record>();
                if (genRecs != null) {
                    lookupRecords.addAll(genRecs);
                }
                if (certRecs == null) break;
                lookupRecords = certRecs.rrs();
                break;
            }
            default: {
                log.debug("Query Type " + (typeString == null ? Integer.valueOf(type) : typeString) + " not implemented");
                throw new DNSException(DNSError.newError(4), "Query Type " + (typeString == null ? Integer.valueOf(type) : typeString) + " not implemented");
            }
        }
        if (lookupRecords == null || lookupRecords.size() == 0) {
            log.debug("No records found.");
            return null;
        }
        Message response = new Message(request.getHeader().getID());
        response.getHeader().setFlag(0);
        if (request.getHeader().getFlag(7)) {
            response.getHeader().setFlag(7);
        }
        response.addRecord(queryRecord, 0);
        Iterator iter = lookupRecords.iterator();
        while (iter.hasNext()) {
            response.addRecord((Record)iter.next(), 1);
        }
        response.getHeader().setFlag(5);
        Record soaRecord = this.checkForSoaRecord(name.toString());
        if (soaRecord != null) {
            response.addRecord(soaRecord, 2);
        }
        log.trace("get(Message) Exit");
        return response;
    }

    protected abstract RRset processGenericRecordRequest(String var1, int var2) throws DNSException;

    protected abstract RRset processCERTRecordRequest(String var1) throws DNSException;

    protected abstract Collection<Record> processGenericANYRecordRequest(String var1) throws DNSException;

    protected abstract Record checkForSoaRecord(String var1);

    protected boolean isCertCompliantWithPolicy(X509Certificate cert) {
        if (this.polFilter == null) {
            return true;
        }
        try {
            return this.polFilter.isCompliant(cert, this.polExpression);
        }
        catch (Exception e) {
            log.warn("Error testing certificate for policy compliance.  Default to compliant.", (Throwable)e);
            return true;
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

