/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns;

import java.io.IOException;
import org.nhindirect.dns.DNSError;
import org.nhindirect.dns.DNSException;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Header;
import org.xbill.DNS.Message;

public abstract class DNSResponder {
    private static final Logger log = LoggerFactory.getLogger(DNSResponder.class);
    protected DNSServerSettings settings;
    protected DNSStore store;

    public DNSResponder(DNSServerSettings settings, DNSStore store) throws DNSException {
        this.settings = settings;
        this.store = store;
    }

    public abstract void start() throws DNSException;

    public abstract void stop() throws DNSException;

    public Message processRequest(byte[] rawMessage) throws DNSException {
        Message msg;
        if (rawMessage == null || rawMessage.length == 0) {
            throw new DNSException(DNSError.newError(1), "Message cannot be null or empty.");
        }
        try {
            msg = new Message(rawMessage);
        }
        catch (IOException e) {
            throw new DNSException(DNSError.newError(1), "IO Exception reading raw message.", e);
        }
        return this.processRequest(msg);
    }

    public Message processRequest(Message request) {
        Message response;
        if (request == null) {
            throw new IllegalArgumentException("Missing request.  Request cannot be null.");
        }
        try {
            response = this.store.get(request);
            if (response == null || response.getHeader() == null) {
                response = this.processError(request, DNSError.newError(3));
            } else if (response.getHeader().getRcode() != 0) {
                response = this.processError(request, DNSError.newError(response.getHeader().getRcode()));
            }
        }
        catch (DNSException e) {
            if (!e.getError().getError().equals(4)) {
                log.error("Error processing DNS request: " + e.getMessage(), (Throwable)e);
            }
            response = this.processError(request, e.getError());
        }
        return response;
    }

    protected Message processError(Message request, DNSError<?> error) {
        Message errorResponse = null;
        try {
            Header respHeader = new Header(request.toWire());
            Message response = new Message();
            response.setHeader(respHeader);
            for (int i = 0; i < 4; ++i) {
                response.removeAllRecords(i);
            }
            response.addRecord(request.getQuestion(), 0);
            response.getHeader().setFlag(0);
            if (request.getHeader().getFlag(7)) {
                response.getHeader().setFlag(7);
            }
            respHeader.setRcode(Integer.parseInt(error.getError().toString()));
            return response;
        }
        catch (IOException iOException) {
            return errorResponse;
        }
    }

    protected Message toMessage(byte[] buffer) throws DNSException {
        if (buffer.length <= 0 || buffer.length > this.settings.getMaxRequestSize()) {
            throw new DNSException(DNSError.newError(5), "Invalid request size " + buffer.length);
        }
        try {
            return new Message(buffer);
        }
        catch (IOException e) {
            throw new DNSException(DNSError.newError(1), "Failed to deserialize raw byte message.");
        }
    }

    protected byte[] toBytes(Message msg) {
        return msg.toWire();
    }
}

