/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns;

import java.lang.management.ManagementFactory;
import java.util.UUID;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.nhindirect.dns.DNSException;
import org.nhindirect.dns.DNSResponder;
import org.nhindirect.dns.DNSResponderTCP;
import org.nhindirect.dns.DNSResponderUDP;
import org.nhindirect.dns.DNSServerMBean;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNSServer
implements DNSServerMBean {
    private static final Logger log = LoggerFactory.getLogger(DNSServer.class);
    private DNSResponder tcpResponder;
    private DNSResponder updResponder;
    private CompositeData settingsData;
    private final String dnsStoreImplName;

    public DNSServer(DNSStore store, DNSServerSettings settings) {
        try {
            this.tcpResponder = new DNSResponderTCP(settings, store);
        }
        catch (DNSException e) {
            log.error("Failed to create TCP responder: " + e.getLocalizedMessage(), (Throwable)e);
        }
        try {
            this.updResponder = new DNSResponderUDP(settings, store);
        }
        catch (DNSException e) {
            log.error("Failed to create UDP responder: " + e.getLocalizedMessage(), (Throwable)e);
        }
        this.dnsStoreImplName = store.getClass().getName();
        this.registerMBean(settings);
    }

    private void registerMBean(DNSServerSettings settings) {
        String[] itemNames = new String[]{"Port", "Bind Address", "Max Request Size", "Max Outstanding Accepts", "Max Active Accepts", "Max Connection Backlog", "Read Buffer Size", "Send Timeout", "Receive Timeout", "Socket Close Timeout"};
        String[] itemDesc = new String[]{"Port", "Bind Address", "Max Request Size", "Max Outstanding Accepts", "Max Active Accepts", "Max Connection Backlog", "Read Buffer Size", "Send Timeout", "Receive Timeout", "Socket Close Timeout"};
        OpenType[] types = new OpenType[]{SimpleType.INTEGER, SimpleType.STRING, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER};
        Object[] settingsValues = new Object[]{settings.getPort(), settings.getBindAddress(), settings.getMaxRequestSize(), settings.getMaxOutstandingAccepts(), settings.getMaxActiveRequests(), settings.getMaxConnectionBacklog(), settings.getReadBufferSize(), settings.getSendTimeout(), settings.getReceiveTimeout(), settings.getSocketCloseTimeout()};
        try {
            CompositeType settingsType = new CompositeType(DNSServerSettings.class.getSimpleName(), "DNS server settings.", itemNames, itemDesc, types);
            this.settingsData = new CompositeDataSupport(settingsType, itemNames, settingsValues);
        }
        catch (OpenDataException e) {
            log.error("Failed to create settings composite type: " + e.getLocalizedMessage(), (Throwable)e);
            return;
        }
        Class<?> clazz = this.getClass();
        StringBuilder objectNameBuilder = new StringBuilder(clazz.getPackage().getName());
        objectNameBuilder.append(":type=").append(clazz.getSimpleName());
        objectNameBuilder.append(",name=").append(UUID.randomUUID());
        try {
            StandardMBean mbean = new StandardMBean(this, DNSServerMBean.class);
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            mbeanServer.registerMBean(mbean, new ObjectName(objectNameBuilder.toString()));
        }
        catch (JMException e) {
            log.error("Unable to register the DNSServer MBean", (Throwable)e);
        }
    }

    public void start() throws DNSException {
        this.tcpResponder.start();
        this.updResponder.start();
    }

    public void stop() throws DNSException {
        this.tcpResponder.stop();
        this.updResponder.stop();
    }

    @Override
    public CompositeData getServerSettings() {
        return this.settingsData;
    }

    @Override
    public void startServer() {
        log.info("Received request to start server.");
        try {
            this.start();
        }
        catch (DNSException e) {
            log.error("Failed to start server: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void stopServer() {
        log.info("Received request to stop server.");
        try {
            this.stop();
        }
        catch (DNSException e) {
            log.error("Failed to stop server: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getDNSStoreImplName() {
        return this.dnsStoreImplName;
    }
}

