/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns;

import java.io.IOException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Collection;
import java.util.stream.Collectors;
import org.nhindirect.dns.DNSException;
import org.nhindirect.dns.DNSStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Message;
import org.xbill.DNS.ResolverConfig;

public class ProxyDNSStore
implements DNSStore {
    private static final Logger log = LoggerFactory.getLogger(ProxyDNSStore.class);
    private static final int DEFAULT_RESOLVER_PORT = 53;
    private final Collection<String> servers;
    private final int port;

    public ProxyDNSStore() {
        this(53);
    }

    public ProxyDNSStore(int port) {
        this(null, 53);
    }

    public ProxyDNSStore(Collection<String> servers) {
        this(servers, 53);
    }

    public ProxyDNSStore(Collection<String> servers, int port) {
        this.servers = servers == null || servers.size() == 0 ? (Collection<Object>)ResolverConfig.getCurrentConfig().servers().stream().map(addr -> addr.getHostString()).collect(Collectors.toList()) : servers;
        this.port = port;
    }

    @Override
    public Message get(Message dnsMsg) throws DNSException {
        ExtendedResolver resolver = this.createExResolver(this.servers, this.port, 2, 2000);
        Message response = null;
        try {
            response = resolver.send(dnsMsg);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (response == null) {
            resolver.setTCP(true);
            try {
                response = resolver.send(dnsMsg);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return response;
    }

    private ExtendedResolver createExResolver(Collection<String> servers, int port, int retries, int timeout) {
        ExtendedResolver retVal = null;
        try {
            retVal = new ExtendedResolver(servers.toArray(new String[servers.size()]));
            retVal.setRetries(retries);
            retVal.setTimeout(Duration.ofSeconds(timeout));
        }
        catch (UnknownHostException e) {
            log.warn("Proxy store resolver could not be created: " + e.getMessage(), (Throwable)e);
        }
        return retVal;
    }
}

